% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stergm.getMCMCsample.R
\name{stergm_MCMC_sample}
\alias{stergm_MCMC_sample}
\alias{stergm_MCMC_slave}
\title{Collects a sample of networks and returns the formation and dissolution
statistics of each sample}
\usage{
stergm_MCMC_sample(
  nw,
  model.form,
  model.diss,
  model.mon,
  proposal.form,
  proposal.diss,
  control,
  theta.form = NULL,
  theta.diss = NULL,
  verbose = FALSE,
  ...,
  eta.form = ergm.eta(theta.form, model.form$etamap),
  eta.diss = ergm.eta(theta.diss, model.diss$etamap)
)

stergm_MCMC_slave(
  Clist.form,
  Clist.diss,
  Clist.mon,
  proposal.form,
  proposal.diss,
  eta.form,
  eta.diss,
  control,
  verbose
)
}
\arguments{
\item{nw}{a \code{\link{network}} object}

\item{model.form, model.diss, model.mon}{formation, dissolution, and
monitoring model, as returned by \code{\link{ergm_model}}}

\item{proposal.form, proposal.diss}{a list of parameters needed for
proposals of the formations and dissolutions}

\item{control}{list of control paramters, probably from
\code{\link{control.stergm}}}

\item{verbose}{logical; whether this and other functions should be verbose}

\item{eta.form, eta.diss}{vectors of natural parameters.}

\item{Clist.form, Clist.diss, Clist.mon}{formation, dissolution, and
monitoring "Clist", as returned by \code{\link{ergm.Cprepare}}}
}
\value{
returns the MCMC sample as a list containing: \itemize{
\item statsmatrix.form: the matrix of sampled statistics for 'model.form'
RELATIVE TO INITIAL NETWORK \item statsmatrix.diss: the matrix of sampled
statistics for 'model.diss' RELATIVE TO INITIAL NETWORK
\item statsmatrix.mon: the matrix of sampled statistics for 'model.mon'
RELATIVE TO INITIAL NETWORK \item newnetwork : the final network from the
sampling process \item changed : a toggle matrix, where the first column is
the timestamp of the toggle and the 2nd and 3rd columns are the head & tail
of the toggle; this is only returned if \code{control$changes} is not NULL
\item maxchanges : the "MCMC Dyn workspace"; see 'maxchanges' in the input
param list }
}
\description{
\code{stergm_MCMC_sample} is a low-level internal function not intended to
be called directly by end users. It collects a sample of networks and
returns the formation and dissolution statistics of each sample, along with
a toggle matrix of the changes needed from the original network to each in
the sample.

\code{stergm_MCMC_slave} is an even
lower-level function that actually calls the C code.
}
\details{
This function is normally called inside \code{\link{simulate.stergm}} to
prepare inputs for the C sampling code and return its results
}
\seealso{
\code{\link{simulate.stergm}}
}
\keyword{internal}
