% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_survival_duration_subgroups.R
\name{h_split_by_subgroups}
\alias{h_split_by_subgroups}
\title{Split Dataframe by Subgroups}
\usage{
h_split_by_subgroups(data, subgroups, groups_lists = list())
}
\arguments{
\item{data}{(\code{data.frame})\cr dataset to split.}

\item{subgroups}{(\code{character})\cr names of factor variables from \code{data} used to create subsets.
Unused levels not present in \code{data} are dropped. Note that the order in this vector
determines the order in the downstream table.}

\item{groups_lists}{(named \code{list} of \code{list})\cr optionally contains for each \code{subgroups} variable a list, which
specifies the new group levels via the names and the levels that belong to it in the character vectors that are
elements of the list.}
}
\value{
A list with subset data (\code{df}) and metadata about the subset (\code{df_labels}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Split a dataframe into a non-nested list of subsets.
}
\details{
Main functionality is to prepare data for use in forest plot layouts.
}
\examples{
df <- data.frame(
  x = c(1:5),
  y = factor(c("A", "B", "A", "B", "A"), levels = c("A", "B", "C")),
  z = factor(c("C", "C", "D", "D", "D"), levels = c("D", "C"))
)
formatters::var_labels(df) <- paste("label for", names(df))

h_split_by_subgroups(
  data = df,
  subgroups = c("y", "z")
)

h_split_by_subgroups(
  data = df,
  subgroups = c("y", "z"),
  groups_lists = list(
    y = list("AB" = c("A", "B"), "C" = "C")
  )
)

}
