% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_diff_test.R
\name{prop_diff_test}
\alias{prop_diff_test}
\alias{s_test_proportion_diff}
\alias{a_test_proportion_diff}
\alias{test_proportion_diff}
\title{Difference Test for Two Proportions}
\usage{
s_test_proportion_diff(
  df,
  .var,
  .ref_group,
  .in_ref_col,
  variables = list(strata = NULL),
  method = c("chisq", "schouten", "fisher", "cmh")
)

a_test_proportion_diff(
  df,
  .var,
  .ref_group,
  .in_ref_col,
  variables = list(strata = NULL),
  method = c("chisq", "schouten", "fisher", "cmh")
)

test_proportion_diff(
  lyt,
  vars,
  ...,
  var_labels = vars,
  show_labels = "hidden",
  table_names = vars,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.ref_group}{(\code{data.frame} or \code{vector})\cr the data corresponding to the reference group.}

\item{.in_ref_col}{(\code{logical})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{method}{(\code{string})\cr one of \code{chisq}, \code{cmh}, \code{fisher}, or \code{schouten}; specifies the test used
to calculate the p-value.}

\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{...}{other arguments are passed to \code{\link[=s_test_proportion_diff]{s_test_proportion_diff()}}.}

\item{var_labels}{(\code{character})\cr character for label.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{table_names}{(\code{character})\cr this can be customized in case that the same \code{vars} are analyzed multiple times,
to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{tbl}{(\code{matrix})\cr matrix with two groups in rows and the binary response (\code{TRUE}/\code{FALSE}) in columns.}
}
\value{
\itemize{
\item \code{s_test_proportion_diff()} returns a named \code{list} with a single item \code{pval} with an attribute \code{label}
describing the method used. The p-value tests the null hypothesis that proportions in two groups are the same.
}

\itemize{
\item \code{a_test_proportion_diff()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{test_proportion_diff()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_test_proportion_diff()} to the table layout.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Various tests were implemented to test the difference between two proportions.
}
\section{Functions}{
\itemize{
\item \code{s_test_proportion_diff()}: Statistics function which tests the difference between two proportions.

\item \code{a_test_proportion_diff()}: Formatted analysis function which is used as \code{afun} in \code{test_proportion_diff()}.

\item \code{test_proportion_diff()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

}}
\examples{
dta <- data.frame(
  rsp = sample(c(TRUE, FALSE), 100, TRUE),
  grp = factor(rep(c("A", "B"), each = 50)),
  strat = factor(rep(c("V", "W", "X", "Y", "Z"), each = 20))
)

# With `rtables` pipelines.
l <- basic_table() \%>\%
  split_cols_by(var = "grp", ref_group = "B") \%>\%
  test_proportion_diff(
    vars = "rsp",
    method = "cmh", variables = list(strata = "strat")
  )

build_table(l, df = dta)

}
\seealso{
\link{h_prop_diff_test}
}
\keyword{internal}
