% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_step.R
\name{g_step}
\alias{g_step}
\title{Create a STEP Graph}
\usage{
g_step(
  df,
  use_percentile = "Percentile Center" \%in\% names(df),
  est = list(col = "blue", lty = 1),
  ci_ribbon = list(fill = getOption("ggplot2.discrete.colour")[1], alpha = 0.5),
  col = getOption("ggplot2.discrete.colour")
)
}
\arguments{
\item{df}{(\code{tibble})\cr result of \code{\link[=tidy.step]{tidy.step()}}.}

\item{use_percentile}{(\code{flag})\cr whether to use percentiles for the x axis or actual
biomarker values.}

\item{est}{(named \code{list})\cr \code{col} and \code{lty} settings for estimate line.}

\item{ci_ribbon}{(named \code{list} or \code{NULL})\cr \code{fill} and \code{alpha} settings for the confidence interval
ribbon area, or \code{NULL} to not plot a CI ribbon.}

\item{col}{(\code{character})\cr colors.}
}
\value{
A \code{ggplot} STEP graph.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Based on the STEP results, creates a \code{ggplot} graph showing the estimated HR or OR
along the continuous biomarker value subgroups.
}
\examples{
library(nestcolor)
library(survival)
lung$sex <- factor(lung$sex)

# Survival example.
vars <- list(
  time = "time",
  event = "status",
  arm = "sex",
  biomarker = "age"
)

step_matrix <- fit_survival_step(
  variables = vars,
  data = lung,
  control = c(control_coxph(), control_step(num_points = 10, degree = 2))
)
step_data <- broom::tidy(step_matrix)

# Default plot.
g_step(step_data)

# Add the reference 1 horizontal line.
library(ggplot2)
g_step(step_data) +
  ggplot2::geom_hline(ggplot2::aes(yintercept = 1), linetype = 2)

# Use actual values instead of percentiles, different color for estimate and no CI,
# use log scale for y axis.
g_step(
  step_data,
  use_percentile = FALSE,
  est = list(col = "blue", lty = 1),
  ci_ribbon = NULL
) + scale_y_log10()

# Adding another curve based on additional column.
step_data$extra <- exp(step_data$`Percentile Center`)
g_step(step_data) +
  ggplot2::geom_line(ggplot2::aes(y = extra), linetype = 2, color = "green")

# Response example.
vars <- list(
  response = "status",
  arm = "sex",
  biomarker = "age"
)

step_matrix <- fit_rsp_step(
  variables = vars,
  data = lung,
  control = c(
    control_logistic(response_definition = "I(response == 2)"),
    control_step()
  )
)
step_data <- broom::tidy(step_matrix)
g_step(step_data)

}
\seealso{
Custom tidy method \code{\link[=tidy.step]{tidy.step()}}.
}
