% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_glm_count.R
\name{h_glm_count}
\alias{h_glm_count}
\alias{h_glm_poisson}
\alias{h_glm_quasipoisson}
\alias{h_ppmeans}
\title{Helper Functions for Poisson Models.}
\usage{
h_glm_poisson(.var, .df_row, variables, weights)

h_glm_quasipoisson(.var, .df_row, variables, weights)

h_glm_count(.var, .df_row, variables, distribution, weights)

h_ppmeans(obj, .df_row, arm, conf_level)
}
\arguments{
\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.df_row}{(\code{data.frame})\cr data set that includes all the variables that are called in \code{.var} and \code{variables}.}

\item{variables}{(named \code{list} of \code{strings})\cr list of additional analysis variables, with
expected elements:
\itemize{
\item \code{arm} (\code{string})\cr group variable, for which the covariate adjusted means of multiple
groups will be summarized. Specifically, the first level of \code{arm} variable is taken as the
reference group.
\item \code{covariates} (\code{character})\cr a vector that can contain single variable names (such as
\code{"X1"}), and/or interaction terms indicated by \code{"X1 * X2"}.
\item \code{offset} (\code{numeric})\cr a numeric vector or scalar adding an offset.
}}

\item{weights}{(\code{character})\cr a character vector specifying weights used
in averaging predictions. Number of weights must equal the number of levels included in the covariates.
Weights option passed to \code{\link[emmeans:emmeans]{emmeans::emmeans()}}.}

\item{distribution}{(\code{character})\cr a character value specifying the distribution
used in the regression (poisson, quasipoisson).}

\item{obj}{(\code{glm.fit})\cr fitted model object used to derive the mean rate estimates in each treatment arm.}

\item{arm}{(\code{string})\cr group variable, for which the covariate adjusted means of multiple groups will be
summarized. Specifically, the first level of \code{arm} variable is taken as the reference group.}

\item{conf_level}{(\code{numeric})\cr value used to derive the confidence interval for the rate.}
}
\value{
\itemize{
\item \code{h_glm_poisson()} returns the results of a Poisson model.
}

\itemize{
\item \code{h_glm_quasipoisson()} returns the results of a Quasi-Poisson model.
}

\itemize{
\item \code{h_glm_count()} returns the results of the selected model.
}

\itemize{
\item \code{h_ppmeans()} returns the estimated means.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Helper functions that can be used to return the results of various Poisson models.
}
\section{Functions}{
\itemize{
\item \code{h_glm_poisson()}: Helper function to return results of a poisson model.

\item \code{h_glm_quasipoisson()}: Helper function to return results of a quasipoisson model.

\item \code{h_glm_count()}: Helper function to return the results of the
selected model (poisson, quasipoisson, negative binomial).

\item \code{h_ppmeans()}: Helper function to return the estimated means.

}}
\seealso{
\link{summarize_glm_count}
}
\keyword{internal}
