% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_ggplot.R
\name{rtable2gg}
\alias{rtable2gg}
\title{Convert \code{rtable} object to \code{ggplot} object}
\usage{
rtable2gg(tbl, fontsize = 4, colwidths = NULL, lbl_col_padding = 0)
}
\arguments{
\item{tbl}{(\code{rtable})\cr a \code{rtable} object.}

\item{fontsize}{(\code{numeric})\cr font size.}

\item{colwidths}{(\code{vector} of \code{numeric})\cr a vector of column widths. Each element's position in
\code{colwidths} corresponds to the column of \code{tbl} in the same position. If \code{NULL}, column widths
are calculated according to maximum number of characters per column.}

\item{lbl_col_padding}{(\code{numeric})\cr additional padding to use when calculating spacing between
the first (label) column and the second column of \code{tbl}. If \code{colwidths} is specified,
the width of the first column becomes \code{colwidths[1] + lbl_col_padding}. Defaults to 0.}
}
\value{
a \code{ggplot} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Given a \code{\link[rtables:rtable]{rtables::rtable()}} object, performs basic conversion to a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object built using
functions from the \code{ggplot2} package. Any table titles and/or footnotes are ignored.
}
\examples{
dta <- data.frame(
  ARM     = rep(LETTERS[1:3], rep(6, 3)),
  AVISIT  = rep(paste0("V", 1:3), 6),
  AVAL    = c(9:1, rep(NA, 9))
)

lyt <- basic_table() \%>\%
  split_cols_by(var = "ARM") \%>\%
  split_rows_by(var = "AVISIT") \%>\%
  analyze_vars(vars = "AVAL")

tbl <- build_table(lyt, df = dta)

rtable2gg(tbl)

rtable2gg(tbl, fontsize = 5, colwidths = c(2, 1, 1, 1))

}
