% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_cumulative.R
\name{count_cumulative}
\alias{count_cumulative}
\alias{s_count_cumulative}
\alias{a_count_cumulative}
\title{Cumulative counts with thresholds}
\usage{
count_cumulative(
  lyt,
  vars,
  thresholds,
  lower_tail = TRUE,
  include_eq = TRUE,
  var_labels = vars,
  show_labels = "visible",
  na_str = default_na_str(),
  nested = TRUE,
  ...,
  table_names = vars,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_count_cumulative(
  x,
  thresholds,
  lower_tail = TRUE,
  include_eq = TRUE,
  .N_col,
  ...
)

a_count_cumulative(
  x,
  thresholds,
  lower_tail = TRUE,
  include_eq = TRUE,
  .N_col,
  ...
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{thresholds}{(\code{numeric})\cr vector of cutoff values for the counts.}

\item{lower_tail}{(\code{flag})\cr whether to count lower tail, default is \code{TRUE}.}

\item{include_eq}{(\code{flag})\cr whether to include value equal to the \code{threshold} in
count, default is \code{TRUE}.}

\item{var_labels}{(\code{character})\cr variable labels.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{...}{additional arguments for the lower level functions.}

\item{table_names}{(\code{character})\cr this can be customized in the case that the same \code{vars} are analyzed multiple
times, to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table. Run \code{get_stats("count_cumulative")}
to see available statistics for this function.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{x}{(\code{numeric})\cr vector of numbers we want to analyze.}

\item{.N_col}{(\code{integer(1)})\cr column-wise N (column count) for the full column being analyzed that is typically
passed by \code{rtables}.}
}
\value{
\itemize{
\item \code{count_cumulative()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_count_cumulative()} to the table layout.
}

\itemize{
\item \code{s_count_cumulative()} returns a named list of \code{count_fraction}s: a list with each \code{thresholds} value as a
component, each component containing a vector for the count and fraction.
}

\itemize{
\item \code{a_count_cumulative()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Summarize cumulative counts of a \code{numeric} vector that is less than, less or equal to,
greater than, or greater or equal to user-specific thresholds.
}
\section{Functions}{
\itemize{
\item \code{count_cumulative()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_count_cumulative()}: Statistics function that produces a named list given a numeric vector of thresholds.

\item \code{a_count_cumulative()}: Formatted analysis function which is used as \code{afun}
in \code{count_cumulative()}.

}}
\examples{
basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  add_colcounts() \%>\%
  count_cumulative(
    vars = "AGE",
    thresholds = c(40, 60)
  ) \%>\%
  build_table(tern_ex_adsl)

}
\seealso{
Relevant helper function \code{\link[=h_count_cumulative]{h_count_cumulative()}}, and descriptive function \code{\link[=d_count_cumulative]{d_count_cumulative()}}.
}
\keyword{internal}
