% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abnormal_by_worst_grade_worsen.R
\name{h_worsen_counter}
\alias{h_worsen_counter}
\title{Helper function to analyze patients for \code{s_count_abnormal_lab_worsen_by_baseline()}}
\usage{
h_worsen_counter(df, id, .var, baseline_var, direction_var)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{id}{(\code{string})\cr subject variable name.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{baseline_var}{(\code{string})\cr name of the baseline lab grade variable.}

\item{direction_var}{(\code{string})\cr name of the direction variable specifying the direction of the shift table of
interest. Only lab records flagged by \code{L}, \code{H} or \code{B} are included in the shift table.
\itemize{
\item \code{L}: low direction only
\item \code{H}: high direction only
\item \code{B}: both low and high directions
}}
}
\value{
The counts and fraction of patients
whose worst post-baseline lab grades are worse than their baseline grades, for
post-baseline worst grades "1", "2", "3", "4" and "Any".
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper function to count the number of patients and the fraction of patients according to
highest post-baseline lab grade variable \code{.var}, baseline lab grade variable \code{baseline_var},
and the direction of interest specified in \code{direction_var}.
}
\examples{
library(dplyr)

# The direction variable, GRADDR, is based on metadata
adlb <- tern_ex_adlb \%>\%
  mutate(
    GRADDR = case_when(
      PARAMCD == "ALT" ~ "B",
      PARAMCD == "CRP" ~ "L",
      PARAMCD == "IGA" ~ "H"
    )
  ) \%>\%
  filter(SAFFL == "Y" & ONTRTFL == "Y" & GRADDR != "")

df <- h_adlb_worsen(
  adlb,
  worst_flag_low = c("WGRLOFL" = "Y"),
  worst_flag_high = c("WGRHIFL" = "Y"),
  direction_var = "GRADDR"
)

# `h_worsen_counter`
h_worsen_counter(
  df \%>\% filter(PARAMCD == "CRP" & GRADDR == "Low"),
  id = "USUBJID",
  .var = "ATOXGR",
  baseline_var = "BTOXGR",
  direction_var = "GRADDR"
)

}
\seealso{
\link{abnormal_by_worst_grade_worsen}
}
