% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/georeference_overlay.R
\name{georeference_overlay}
\alias{georeference_overlay}
\title{Georeference image overlays based on a reference raster}
\usage{
georeference_overlay(
  overlay_file,
  reference_raster,
  output_file = tempfile(fileext = ".tif")
)
}
\arguments{
\item{overlay_file}{The image overlay to georeference. File format will be
detected automatically from file extension; options include `jpeg/jpg`,
`png`, and `tif/tiff`.}

\item{reference_raster}{The raster file to base georeferencing on. The output
image will have the same extent and CRS as the reference raster. Accepts both
Raster* objects from the `raster` package or a file readable by
[raster::raster].}

\item{output_file}{The path to write the georeferenced image file to. Must
be a TIFF.}
}
\value{
The file path written to, invisibly.
}
\description{
This function georeferences an image overlay based on a reference raster,
setting the extent and CRS of the image to those of the raster file. To
georeference multiple images and merge them into a single file, see
[merge_rasters].
}
\examples{
\dontrun{
simulated_data <- data.frame(
  id = seq(1, 100, 1),
  lat = runif(100, 44.1114, 44.1123),
  lng = runif(100, -73.92273, -73.92147)
)

simulated_data <- sf::st_as_sf(simulated_data, coords = c("lng", "lat"))

downloaded_tiles <- get_tiles(simulated_data,
                              services = c("elevation", "ortho"),
                              georeference = FALSE)

georeference_overlay(
  overlay_file = downloaded_tiles[[2]],
  reference_raster = downloaded_tiles[[1]],
  output_file = tempfile(fileext = ".tif")
)
}

}
\seealso{
Other data manipulation functions: 
\code{\link{combine_overlays}()},
\code{\link{merge_rasters}()},
\code{\link{raster_to_raw_tiles}()},
\code{\link{vector_to_overlay}()}

Other overlay creation functions: 
\code{\link{combine_overlays}()},
\code{\link{vector_to_overlay}()}
}
\concept{data manipulation functions}
\concept{overlay creation functions}
