% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KPlot.R
\name{AUK}
\alias{AUK}
\title{Draw Kendall plot and compute AUK.}
\usage{
AUK(x, y, plot = F, main = "Kendall plot", Auxiliary.line = T,
  BS.CI = 0, set.seed = FALSE)
}
\arguments{
\item{x}{a numeric vector stores first variable.}

\item{y}{numeric vector stores second variable.}

\item{plot}{a TRUE/ FALSE flag for generating Kendall plot or not.}

\item{main}{a character indicating the title of the plot.}

\item{Auxiliary.line}{a TRUE/ FALSE flag for drawing auxiliary lines or not.}

\item{BS.CI}{a numeric specifying alpha for Bootstrap confidence interval. When euqal 0, confidence interval won't be computed.}

\item{set.seed}{a TRUE/ FALSE flag specifying setting seed or not.}
}
\value{
a list containing a numeric AUK, a numeric vector W.in (x axis of plot), a numeric vector Hi.sort (y axis of plot), and three confidence intervals: normal CI, pivotal CI and percentage CI.
}
\description{
This function draws Kendall plot of 2 variables. Also provides an index AUK (area under Kendall plot).
}
\details{
AUK is bounded between 0 and 0.75. For positively correlated x and y's, say x = y, AUK = 0.75. And the plot follows the concave auxiliary line. While negatively correlated x and y's, AUK = 0. The plot is horizontal on y = 0. For independent x and y, AUK = 0.5. Kendall plot is on the diagonal.
Due to possible variable overflow, this function is only suitable for input size less than 1000. Input size greater than 1000 causes error.
}
\examples{
set.seed(123)
x = runif(100)
y = runif(100)

result = AUK(x, y, plot = TRUE)
result$AUK

#[1] 0.4987523
}
\author{
Jeffrey C. Miecznikowski, En-shuo Hsu, Yanhua Chen, Albert Vexler
}
\references{
Vexler, Albert, Xiwei Chen, and Alan D. Hutson. "Dependence and independence: Structure and inference." Statistical methods in medical research (2015): 0962280215594198.

R package "VineCopula":
Schepsmeier, Ulf, et al. "Package 'VineCopula'." (2015).
}

