% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulas.R
\name{copula}
\alias{copula}
\alias{copula.default}
\alias{copula.data.frame}
\alias{copula.matrix}
\title{Calculate the copula of a matrix of variables}
\usage{
copula(x, na.last = NA, ...)

\method{copula}{default}(x, na.last = NA, ...)

\method{copula}{data.frame}(x, na.last = NA, ...)

\method{copula}{matrix}(x, na.last = NA, ...)
}
\arguments{
\item{x}{A matrix or data.frame containing numeric variables.}

\item{na.last}{How to treat missing values. See \code{rank} for details.}

\item{...}{further arguments}
}
\value{
A matrix with the same dimensions as \code{x}, each column of which
contains the quantiles of each column of \code{x}. This object is of class
\code{copula}.
}
\description{
Returns the copula of several random variables.
}
\details{
The result is obtained by applying \code{\link{edf}} to each column of
\code{x} in turn.

Print and plot methods are available for the copula class.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method

\item \code{data.frame}: data frame method

\item \code{matrix}: matrix method
}}

\examples{

  D <- liver[liver$dose == "D",]
  Dco <- copula(D)
  plot(Dco)

}
\seealso{
\code{\link{edf}} \code{\link{plot.copula}}
}
\author{
Harry Southworth
}
\keyword{multivariate}
