% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf-tools.R
\name{convert_to_png}
\alias{convert_to_png}
\title{convert one single pdf file to png}
\usage{
convert_to_png(file_path, dpi = 180)
}
\arguments{
\item{file_path}{path to the pdf file}

\item{dpi}{Set DPI for converting PDF files. default: 180}
}
\value{
png file of the same
}
\description{
function to invoke `pdftools:pdf_convert()`

This function is designed to be used internally and is called
by `texor::pdf_to_png(file_dir)` function for converting individual of pdf
image.

Note : The extensions in LaTeX source code will
automatically be changed during pandoc conversion
by a lua filter (refer : inst/extdata/image_filter.lua)
}
\note{
If you find inconsistencies in the raster image generated from PDF using this
 function. Please update poppler utils to newer versions (possibly latest one).
}
\examples{
article_dir <- system.file("examples/pdf_conversion",
                 package = "texor")
dir.create(your_article_folder <- file.path(tempdir(), "tempdir"))
x <- file.copy(from = article_dir, to = your_article_folder,recursive = TRUE,)
your_article_path <- paste(your_article_folder,"pdf_conversion",sep="/")
rmarkdown::pandoc_version()
texor::convert_to_png(paste0(your_article_path,"/normal.pdf"))
unlink(your_article_folder,recursive = TRUE)
}
