% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-dtm.R
\name{seq_builder}
\alias{seq_builder}
\title{Represent Documents as Token-Integer Sequences}
\usage{
seq_builder(
  data,
  text,
  doc_id = NULL,
  vocab = NULL,
  maxlen = NULL,
  matrix = TRUE
)
}
\arguments{
\item{data}{Data.frame with column of texts and column of document ids}

\item{text}{Name of the column with documents' text}

\item{doc_id}{Name of the column with documents' unique ids.}

\item{vocab}{Default is \code{NULL}, if a list of terms is provided,
the function will return a DTM with terms restricted
to this vocabulary. Columns will also be in the same
order as the list of terms.}

\item{maxlen}{Integer indicating the maximum document length.
If NULL (default), the length of the longest document is used.}

\item{matrix}{Logical, \code{TRUE} (default) returns a matrix, \code{FALSE} a list}
}
\value{
returns a matrix or list
}
\description{
First, each token in the vocabulary is mapped to an integer
in a lookup dictionary. Next, documents are converted to sequences
of integers where each integer is an index of the token
from the dictionary.
}
\details{
Function will return a matrix of integer sequences by default.
The columns will be the length of the longest document or
\code{maxlen}, with shorter documents padded with zeros. The
dictionary will be an attribute of the matrix accessed with
\code{attr(seq, "dic")}. If \code{matrix = FALSE}, the function will
return a list of integer sequences. The vocabulary will either
be each unique token in the corpus, or a the list of words
provided to the \code{vocab} argument. This kind of text
representation is used in \href{https://www.tensorflow.org/api_docs/python/tf/keras/preprocessing/text/Tokenizer}{tensorflow} and \href{https://tensorflow.rstudio.com/reference/keras/texts_to_sequences}{keras}.
}
\author{
Dustin Stoltz
}
