% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_LDA.R
\docType{data}
\name{LatentDirichletAllocation}
\alias{LDA}
\alias{LatentDirichletAllocation}
\title{Creates Latent Dirichlet Allocation model.}
\format{\code{\link{R6Class}} object.}
\usage{
LatentDirichletAllocation

LDA
}
\description{
Creates Latent Dirichlet Allocation model.
}
\section{Fields}{

\describe{
\item{\code{verbose}}{\code{logical = TRUE} whether to display training inforamtion}
}}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
lda = LatentDirichletAllocation$new(n_topics, vocabulary,
              doc_topic_prior = 1 / n_topics, topic_word_prior = 1 / n_topics)
lda$fit(x, n_iter, convergence_tol = -1, check_convergence_every_n = 0)
lda$fit_transform(x, n_iter, convergence_tol = -1, check_convergence_every_n = 0)
lda$get_word_vectors()
}
}

\section{Methods}{

\describe{
  \item{\code{$new(n_topics, vocabulary,
              doc_topic_prior = 1 / n_topics, # alpha
              topic_word_prior = 1 / n_topics)}}{Constructor for LDA vectors model.
                    For description of arguments see \bold{Arguments} section.}
  \item{\code{$fit(x, n_iter, convergence_tol = -1,
               check_convergence_every_n = 0)}}{fit LDA model to input matrix \code{x}}
  \item{\code{$fit_transform(x, n_iter, convergence_tol = -1,
               check_convergence_every_n = 0)}}{fit LDA model to input matrix \code{x}
               and transforms input documents to topic space}
  \item{\code{$transform(x, n_iter = 100, convergence_tol = 0.005,
               check_convergence_every_n = 1)}}{ transforms new documents to topic space}
  \item{\code{$get_word_vectors()}}{get word-topic distribution}
  \item{\code{$plot(...)}}{plot LDA model using \url{https://cran.r-project.org/package=LDAvis} package.
               \code{...} will be passed to \code{LDAvis::createJSON} and \code{LDAvis::serVis} functions}
}
}

\section{Arguments}{

\describe{
 \item{lda}{A \code{LDA} object}
 \item{x}{An input document-term matrix.}
 \item{n_topics}{\code{integer} desired number of latent topics. Also knows as \bold{K}}
 \item{vocabulary}{vocabulary in a form of \code{character} or \code{text2vec_vocab} }
 \item{doc_topic_prior}{\code{numeric} prior for document-topic multinomial distribution.
   Also knows as \bold{alpha}}
 \item{topic_word_prior}{\code{numeric} prior for topic-word multinomial distribution.
   Also knows as \bold{eta}}
 \item{n_iter}{\code{integer} number of Gibbs iterations}
 \item{convergence_tol}{{\code{numeric = -1} defines early stopping strategy. We stop fitting
    when one of two following conditions will be satisfied: (a) we have used
    all iterations, or (b) \code{perplexity_previous_iter / perplexity_current_iter - 1 <
    convergence_tol}. By default perform all iterations.}}
 \item{check_convergence_every_n}{\code{integer} Defines frequency of perplexity calculation.
   In some cases perplexity calculation during LDA fitting can take noticable amount of time.
   It make sense to do not calculate it at each iteration.}
}
}
\examples{
library(text2vec)
data("movie_review")
N = 500
tokens = movie_review$review[1:N] \%>\% tolower \%>\% word_tokenizer
it = itoken(tokens, ids = movie_review$id[1:N])
v = create_vocabulary(it) \%>\%
  prune_vocabulary(term_count_min = 5, doc_proportion_max = 0.2)
dtm = create_dtm(it, vocab_vectorizer(v), 'lda_c')
lda_model = LatentDirichletAllocation$new(n_topics = 10, vocabulary = v,
 doc_topic_prior = 0.1,
 topic_word_prior = 0.1)
 doc_topic_distr = lda_model$fit_transform(dtm, n_iter =20, check_convergence_every_n = 5)
 # run LDAvis visualisation if needed (make sure LDAvis package installed)
 # lda_model$plot()
}
\keyword{datasets}

