% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analogies.R
\name{check_analogy_accuracy}
\alias{check_analogy_accuracy}
\title{Checks accuracy of word embeddings on the analogy task}
\usage{
check_analogy_accuracy(questions_list, m_word_vectors)
}
\arguments{
\item{questions_list}{\code{list} of questions. Each element of
\code{questions_list} is a \code{integer matrix} with four columns. It
represents a set of questions related to a particular category. Each
element of matrix is an index of a row in \code{m_word_vectors}. See output
of \link{prepare_analogy_questions} for details}

\item{m_word_vectors}{word vectors \code{numeric matrix}. Each row should
represent a word.}
}
\description{
This function checks how well the GloVe word embeddings do on
  the analogy task. For full examples see \link{glove}.
}
\seealso{
\link{prepare_analogy_questions}, \link{glove}
}
