% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_tabular.R
\name{TexSave}
\alias{TexSave}
\title{Compile a tabular object to a pdf file}
\usage{
TexSave(
  tab,
  filename,
  positions,
  pretty_rules = TRUE,
  output_path = getwd(),
  stand_alone = FALSE,
  compile_tex = FALSE
)
}
\arguments{
\item{tab}{textab block, created by TexRow().}

\item{filename}{(character). The file will be saved as filename.tex.}

\item{positions}{(character). Vector of positions, e.g., "c("l","c","r")" means that the first column will be left-aligned, second column will be center-aligned, and third column will be right-aligned.}

\item{pretty_rules}{(logical). If TRUE, extra formatting rules will be added to the bottom and top of the tabular.}

\item{output_path}{(character). This is the directory path where the file should be saved. Default is the current directory.}

\item{stand_alone}{(logical). If TRUE, the tabular will be exported in a .tex file that can be compiled to PDF directly (rather than included in a separate .tex file). Default is FALSE.}

\item{compile_tex}{(logical). If TRUE and stand_alone is TRUE, pdflatex is used to compile the TeX table into a PDF. This is only allowed if stand_alone=TRUE. Default is FALSE.}
}
\value{
A list containing the path to the .tex file and the name of the .tex file.
}
\description{
Compile a tabular object to a pdf file
}
\examples{
# consider the following example textab object:
tt = TexRow(c("hello", "world")) + TexRow(c(1,2))

# define the positions for each column:
pos = c("l","c")

# choose an output path:
op = tempdir()

# Save a simple .tex document containing this table:
TexSave(tab = tt, positions = pos, filename = "example1", output_path = op)

# Save the .tex document as stand-alone, which includes LaTeX headers and packages:
TexSave(tab = tt, positions = pos, filename = "example2", output_path = op, stand_alone = TRUE)

}
