% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textfeature.R
\name{step_textfeature}
\alias{step_textfeature}
\alias{tidy.step_textfeature}
\title{Generate the basic set of text features}
\usage{
step_textfeature(recipe, ..., role = "predictor", trained = FALSE,
  columns = NULL, extract_functions = count_functions,
  prefix = "textfeature", skip = FALSE, id = rand_id("textfeature"))

\method{tidy}{step_textfeature}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables.
For `step_textfeature`, this indicates the variables to be encoded
into a list column. See [recipes::selections()] for more
details. For the `tidy` method, these are not currently used.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new columns created by the original variables will be 
used as predictors in a model.}

\item{trained}{A logical to indicate if the recipe has been
baked.}

\item{columns}{A list of tibble results that define the
encoding. This is `NULL` until the step is trained by
[recipes::prep.recipe()].}

\item{extract_functions}{A named list of feature extracting functions. 
default to [count_functions] from the textfeatures package. See 
details for more information.}

\item{prefix}{A prefix for generated column names, default to "textfeature".}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by [recipes::bake.recipe()]? While all
operations are baked when [recipes::prep.recipe()] is run, some
operations may not be able to be conducted on new data (e.g.
processing the outcome variable(s)). Care should be taken when
using `skip = TRUE` as it may affect the computations for
subsequent operations.}

\item{id}{A character string that is unique to this step to identify it}

\item{x}{A `step_textfeature` object.}
}
\value{
An updated version of `recipe` with the new step added
 to the sequence of existing steps (if any).
}
\description{
`step_textfeature` creates a *specification* of a recipe step that
 will extract a number of numeric features of a text column.
}
\details{
This step will take a character column and returns a number of numeric 
columns equal to the number of functions in the list passed to the 
`extract_functions` argument. The default is a list of functions from the 
textfeatures package.

All the functions passed to `extract_functions` must take a character vector
as input and return a numeric vector of the same length, otherwise an error 
will be thrown.
}
\examples{
library(recipes)

data(okc_text)

okc_rec <- recipe(~ ., data = okc_text) \%>\%
  step_textfeature(essay0) 
  
okc_obj <- okc_rec \%>\%
  prep(training = okc_text, retain = TRUE)

juice(okc_obj) \%>\%
  slice(1:2)

juice(okc_obj) \%>\%
  pull(textfeature_essay0_n_words)
  
tidy(okc_rec, number = 1)
tidy(okc_obj, number = 1)

# Using custom extraction functions
nchar_round_10 <- function(x) round(nchar(x) / 10) * 10

recipe(~ ., data = okc_text) \%>\%
  step_textfeature(essay0, 
                   extract_functions = list(nchar10 = nchar_round_10)) \%>\%
  prep(training = okc_text) \%>\%
  juice()

}
