% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word2vec.R
\name{step_word2vec}
\alias{step_word2vec}
\alias{tidy.step_word2vec}
\title{Calculates word2vec dimension estimates}
\source{
\url{https://arxiv.org/abs/1301.3781}
}
\usage{
step_word2vec(recipe, ..., role = "predictor", trained = FALSE,
  columns = NULL, lda_models = NULL, num_topics = 10,
  prefix = "word2vec", skip = FALSE, id = rand_id("word2vec"))

\method{tidy}{step_word2vec}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables.
For `step_word2vec`, this indicates the variables to be encoded
into a list column. See [recipes::selections()] for more
details. For the `tidy` method, these are not currently used.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new columns created by the original variables will be
used as predictors in a model.}

\item{trained}{A logical to indicate if the recipe has been
baked.}

\item{columns}{A list of tibble results that define the
encoding. This is `NULL` until the step is trained by
[recipes::prep.recipe()].}

\item{lda_models}{A WarpLDA model object from the text2vec package. If left
to NULL, the default, will it train its model based on the training data.
Look at the examples for how to fit a WarpLDA model.}

\item{num_topics}{integer desired number of latent topics.}

\item{prefix}{A prefix for generated column names, default to "word2vec".}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by [recipes::bake.recipe()]? While all
operations are baked when [recipes::prep.recipe()] is run, some
operations may not be able to be conducted on new data (e.g.
processing the outcome variable(s)). Care should be taken when
using `skip = TRUE` as it may affect the computations for
subsequent operations.}

\item{id}{A character string that is unique to this step to identify it}

\item{x}{A `step_word2vec` object.}
}
\value{
An updated version of `recipe` with the new step added
 to the sequence of existing steps (if any).
}
\description{
\lifecycle{experimental}
`step_word2vec` creates a *specification* of a recipe step that
will return the word2vec dimension estimates of a text variable.
}
\examples{
library(recipes)

data(okc_text)

okc_rec <- recipe(~ ., data = okc_text) \%>\%
  step_word2vec(essay0)

okc_obj <- okc_rec \%>\%
  prep(training = okc_text, retain = TRUE)

juice(okc_obj) \%>\%
  slice(1:2)
tidy(okc_rec, number = 1)
tidy(okc_obj, number = 1)

# Changing the number of topics.
recipe(~ ., data = okc_text) \%>\%
  step_word2vec(essay0, essay1, num_topics = 20) \%>\%
  prep() \%>\%
  juice() \%>\%
  slice(1:2)

# Supplying A pre-trained LDA model trained using text2vec
library(text2vec)
tokens <- word_tokenizer(tolower(okc_text$essay5))
it <- itoken(tokens, ids = seq_along(okc_text$essay5))
v <- create_vocabulary(it)
dtm <- create_dtm(it, vocab_vectorizer(v))
lda_model <- LDA$new(n_topics = 15)

recipe(~ ., data = okc_text) \%>\%
  step_word2vec(essay0, essay1, lda_models = lda_model) \%>\%
  prep() \%>\%
  juice() \%>\%
  slice(1:2)

}
