% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_matrix.R
\name{tidy_matrix}
\alias{tidy_matrix}
\alias{tidy_adjacency_matrix}
\title{Convert a Matrix into Tidy Form}
\usage{
tidy_matrix(x, row.name = "row", col.name = "col", value.name = "value",
  ...)

tidy_adjacency_matrix(x, ...)
}
\arguments{
\item{x}{A matrix.}

\item{row.name}{A string to use for the row names that are now a column.}

\item{col.name}{A string to use for the column names that are now a column.}

\item{value.name}{A string to use for the values that are now a column.}

\item{\ldots}{ignored.}
}
\value{
Returns a tidied \code{data.frame}.
}
\description{
\code{tidy_matrix} - Converts matrices into a tidy data set.  Essentially, a
stacking of the matrix columns and repeating row/column names as necessary.

\code{tidy_adjacency_matrix} - A wrapper for \code{tidy_matrix} with the 
\code{row.name}, \code{col.name}, & \code{value.name} all set to \code{"from"},
\code{"to"}, & \code{"n"}, assuming peparation for network analysis.
}
\examples{
mat <- matrix(1:16, nrow = 4,
    dimnames = list(LETTERS[1:4], LETTERS[23:26])
)

mat
tidy_matrix(mat)


data(simple_dtm)
tidy_matrix(as.matrix(simple_dtm), 'doc', 'term', 'n')

X <- as.matrix(simple_dtm[1:10, 1:10])
tidy_adjacency_matrix(crossprod(X))
tidy_adjacency_matrix(crossprod(t(X)))
}
