% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-format.R
\name{print.tf}
\alias{print.tf}
\alias{print.tfd_reg}
\alias{print.tfd_irreg}
\alias{print.tfb}
\alias{format.tf}
\title{Pretty printing and formatting for functional data}
\usage{
\method{print}{tf}(x, n = 5, ...)

\method{print}{tfd_reg}(x, n = 5, ...)

\method{print}{tfd_irreg}(x, n = 5, ...)

\method{print}{tfb}(x, n = 5, ...)

\method{format}{tf}(
  x,
  digits = 2,
  nsmall = 0,
  width = options()$width,
  n = 5,
  prefix = TRUE,
  ...
)
}
\arguments{
\item{x}{any \R object (conceptually); typically numeric.}

\item{n}{how many elements of \code{x} to print out}

\item{...}{further arguments passed to or from other methods.}

\item{digits}{a positive integer indicating how many significant digits
    are to be used for
    numeric and complex \code{x}.  The default, \code{NULL}, uses
    \code{\link[base]{getOption}("digits")}.  This is a suggestion: enough decimal
    places will be used so that the smallest (in magnitude) number has
    this many significant digits, and also to satisfy \code{nsmall}.
    (For more, notably the interpretation for complex numbers see
    \code{\link[base]{signif}}.)}

\item{nsmall}{the minimum number of digits to the right of the decimal
    point in formatting real/complex numbers in non-scientific formats.
    Allowed values are \code{0 <= nsmall <= 20}.}

\item{width}{\code{default} method: the \emph{minimum} field width or
    \code{NULL} or \code{0} for no restriction.

    \code{AsIs} method: the \emph{maximum} field width for non-character
    objects.  \code{NULL} corresponds to the default \code{12}.
  }

\item{prefix}{used internally.}
}
\value{
prints out \code{x} and returns it invisibly
}
\description{
Print/format \code{tf}-objects.
}
\concept{tidyfun print}
