% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{view_function_graph}
\alias{view_function_graph}
\title{Visualizes the generated graph}
\usage{
view_function_graph(
  fn,
  args,
  ...,
  name = deparse(substitute(fn)),
  profiler = FALSE,
  concrete_fn = do.call(fn$get_concrete_fn, args),
  graph = concrete_fn$graph
)
}
\arguments{
\item{fn}{TensorFlow function (returned from \code{tf.function()})}

\item{args}{arguments passed to \code{fun}}

\item{...}{other arguments passed to \code{\link[tensorflow:tensorboard]{tensorflow::tensorboard()}}}

\item{name}{string, provided to tensorboard}

\item{profiler}{logical, passed on to \code{tf.compat.v2.summary.trace_on()} (only
used in eager mode)}

\item{concrete_fn}{a \code{ConcreteFunction} (only used in graph mode, ignored
with a warning if executing eagerly)}

\item{graph}{a tensorflow graph (only used in graph mode, ignored with a
warning if executing eagerly)}
}
\description{
Visualizes the generated graph
}
\examples{
\dontrun{
fn <- tf_function(function(x) autograph(if(x > 0) x * x else x))
view_function_graph(fn, list(tf$constant(5)))
}
}
