% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_spec.R
\name{step_categorical_column_with_vocabulary_file}
\alias{step_categorical_column_with_vocabulary_file}
\title{Creates a categorical column with vocabulary file}
\usage{
step_categorical_column_with_vocabulary_file(
  spec,
  ...,
  vocabulary_file,
  vocabulary_size = NULL,
  dtype = tf$string,
  default_value = NULL,
  num_oov_buckets = 0L
)
}
\arguments{
\item{spec}{A feature specification created with \code{\link[=feature_spec]{feature_spec()}}.}

\item{...}{Comma separated list of variable names to apply the step. \link{selectors} can also be used.}

\item{vocabulary_file}{The vocabulary file name.}

\item{vocabulary_size}{Number of the elements in the vocabulary. This
must be no greater than length of \code{vocabulary_file}, if less than
length, later values are ignored. If None, it is set to the length of
\code{vocabulary_file}.}

\item{dtype}{The type of features. Only string and integer types are
supported.}

\item{default_value}{The integer ID value to return for out-of-vocabulary
feature values, defaults to \code{-1}. This can not be specified with a
positive \code{num_oov_buckets}.}

\item{num_oov_buckets}{Non-negative integer, the number of out-of-vocabulary
buckets. All out-of-vocabulary inputs will be assigned IDs in the range
\verb{[vocabulary_size, vocabulary_size+num_oov_buckets)} based on a hash of
the input value. A positive \code{num_oov_buckets} can not be specified with
default_value.}
}
\value{
a \code{FeatureSpec} object.
}
\description{
Use this function when the vocabulary of a categorical variable
is written to a file.
}
\examples{
\dontrun{
library(tfdatasets)
data(hearts)
file <- tempfile()
writeLines(unique(hearts$thal), file)
hearts <- tensor_slices_dataset(hearts) \%>\% dataset_batch(32)

# use the formula interface
spec <- feature_spec(hearts, target ~ thal) \%>\%
  step_categorical_column_with_vocabulary_file(thal, vocabulary_file = file)

spec_fit <- fit(spec)
final_dataset <- hearts \%>\% dataset_use_spec(spec_fit)
}

}
\seealso{
\link{steps} for a complete list of allowed steps.

Other Feature Spec Functions: 
\code{\link{dataset_use_spec}()},
\code{\link{feature_spec}()},
\code{\link{fit.FeatureSpec}()},
\code{\link{step_bucketized_column}()},
\code{\link{step_categorical_column_with_hash_bucket}()},
\code{\link{step_categorical_column_with_identity}()},
\code{\link{step_categorical_column_with_vocabulary_list}()},
\code{\link{step_crossed_column}()},
\code{\link{step_embedding_column}()},
\code{\link{step_indicator_column}()},
\code{\link{step_numeric_column}()},
\code{\link{step_remove_column}()},
\code{\link{step_shared_embeddings_column}()},
\code{\link{steps}}
}
\concept{Feature Spec Functions}
