#******************************************************************************* 
#
# Bayesian Regression and Adaptive Sampling with Gaussian Process Trees
# Copyright (C) 2005, University of California
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Questions? Contact Robert B. Gramacy (rbgramacy@ams.ucsc.edu)
#
#*******************************************************************************


"interp.loess" <-
function(x, y, z, gridlen = 40, span=0.1, ...)
{
  if(length(x) != length(y) && length(y) != length(z))
    stop("length of x, y and z must be equal")

  if(length(x) < 30 && span < 0.5) {
    warning("with less than 30 points, suggest span >> 0.5 or use akima",
            immediate. = TRUE)
    cat(paste("currently trying span =", span, "for", length(x), "points\n"))
  }
  
  xo <- seq(min(x), max(x), length=gridlen)
  yo <- seq(min(y), max(y), length=gridlen)

  xyz.loess <-
    suppressWarnings(loess(z ~ x + y, data.frame(x=x, y=y), span=span, ...))

  g <- expand.grid(x=xo, y=yo)
  g.pred <- predict(xyz.loess, g)
  return(list(x=xo, y=yo, z=matrix(g.pred, nrow=gridlen)))
}
