% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ithresh_methods.R
\name{plot.ithresh}
\alias{plot.ithresh}
\title{Plot diagnostics an ithresh object}
\usage{
\method{plot}{ithresh}(
  x,
  y,
  ...,
  which_v = NULL,
  prob = TRUE,
  top_scale = TRUE,
  add_legend = FALSE,
  legend_pos = "topleft",
  which_u = NULL
)
}
\arguments{
\item{x}{an object of class \code{"ithresh"}, a result of a call to
\code{\link{ithresh}}.}

\item{y}{Not used.}

\item{...}{Additional arguments passed on to \code{\link[graphics]{matplot}}
and/or \code{\link[graphics]{legend}} and/or \code{\link[graphics]{axis}}.
If \code{which_u} is supplied then these arguments are passed to
\code{\link[revdbayes]{plot.evpost}}.}

\item{which_v}{A numeric scalar or vector.

  If \code{which_u} is not supplied (a threshold diagnostic plot is
  required) \code{which_v} specifies the validation thresholds, that
  is, the components of \code{x$v_vec}, to include in the plot.

  If \code{which_u} is supplied (a plot of a posterior sample for a given
  threshold is required) then \code{which_v} is a numeric scalar
  that indicates which element of \code{object$v_vec} is used in selecting
  a single threshold (if \code{which_u = "best"}).
  Note: the default, \code{which_v = 1} gives the \emph{lowest} of the
  validation thresholds in \code{object$v_vec}.}

\item{prob}{A logical scalar.  If \code{TRUE} then the levels of thresholds
are represented by the proportion of observations that lie below a
threshold.  If \code{prob = FALSE} then the values of the thresholds are
used.}

\item{top_scale}{A logical scalar indicating Whether or not to add a scale
to the top horizontal axis.  If this is added it gives the threshold on
the scale not chosen by \code{prob}.}

\item{add_legend}{A logical scalar indicating whether or not to add a
legend to the plot.  If \code{method = "cv"} then the legend gives the
levels of the validation thresholds.}

\item{legend_pos}{The position of the legend (if required) specified using
the argument \code{x} in \code{\link[graphics]{legend}}.}

\item{which_u}{Either a character scalar or a numeric scalar.
  If \code{which_u} is supplied then \code{\link[revdbayes]{plot.evpost}}
  is used to produce a plot of the posterior sample generated using
  a particular training threshold. By default a scatter plot of the posterior
  sample of Generalized Pareto parameters is produced.

  If \code{which_u = "best"} then the training threshold achieving the largest
  measure of predictive performance in \code{object$pred_perf}, based
  on the validation threshold selected using \code{which_v}, is used.
  See \code{\link{summary.ithresh}} to print the best thresholds for each
  validation threshold.

  Otherwise, \code{which_u} is a numeric scalar that selects training
  threshold \code{x$u_vec[which_u]}.  Therefore, \code{which_u} must
  be an integer in {1, ..., \code{length(x$u_vec)}}.}
}
\value{
If \code{which_u} is supplied then the object with which
  \code{\link[revdbayes]{plot.evpost}} was called is returned (invisibly).
  Otherwise, a list is returned (again invisibly) with two components.
  \code{x} is a vector containing the coordinates plotted on the
  (lower) horizontal axis.
  \code{y} is an \code{length(u_vec)} by \code{n_v} matrix of
  \emph{threshold weights} obtained by normalising the columns of the
  matrix \code{pred_perf} returned by \code{\link{ithresh}}.
  See equation (14) of Northrop et al. (2017).
}
\description{
\code{plot} method for class \code{"ithresh"}.  Produces an extreme value
threshold diagnostic plot based on an analysis performed by
\code{\link{ithresh}}.  Can also be used to produce a plot of
the posterior sample generated by \code{\link{ithresh}} for a particular
training threshold.
}
\details{
Produces plots of the \emph{threshold weights}, defined in
 equation (14) of Northrop et al. (2017) against training threshold.  A line
 is produced for each of the validation thresholds chosen in \code{which_v}.
 The result is a plot like those in the top row of Figure 7 in
 Northrop et al. (2017).

  It is possible that a curve on the plot may be incomplete.  This indicates
  that, for a particular threshold level, a measure of predictive
  performance is \code{-Inf}. This occurs when an observation in the data
  lies above the estimated upper end point of the predictive distribution
  produced when this observation is removed.
}
\examples{
# [Smoother plots result from making n larger than the default n = 1000.]

# Threshold diagnostic plot
u_vec_gom <- quantile(gom, probs = seq(0, 0.9, by = 0.05))
gom_cv <- ithresh(data = gom, u_vec = u_vec_gom, n_v = 3)
plot(gom_cv, lwd = 2, add_legend = TRUE, legend_pos = "topleft")
mtext("significant wave height / m", side = 3, line = 2.5)

# Plot of Generalized Pareto posterior sample at the best threshold
# (based on the lowest validation threshold)
plot(gom_cv, which_u = "best")
# See which threshold was used
summary(gom_cv)

# Plot of Generalized Pareto posterior sample at the highest threshold
n_u <- length(u_vec_gom)
plot(gom_cv, which_u = n_u, points_par = list(pch = 20, col = "grey"))
}
\seealso{
\code{\link{ithresh}} for threshold selection in the i.i.d. case
  based on leave-one-out cross-validation.

\code{\link{summary.ithresh}} Summarizing measures of threshold
  predictive performance.

\code{\link{print.ithresh}} Prints the threshold weights.

\code{\link{predict.ithresh}} for predictive inference for the
  largest value observed in N years.
}
