% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpc.R
\name{make_server}
\alias{make_server}
\title{Create server side thrift API}
\usage{
make_server(service, handler, host = "localhost", port = 9090,
  proto_factory = TBinaryProtocolFactory$new(),
  trans_factory = TBufferedTransportFactory$new())
}
\arguments{
\item{service}{parsed service}

\item{handler}{R6 class implementing service}

\item{host}{server host}

\item{port}{port server tcp port}

\item{proto_factory}{factory that generates protocol implementation}

\item{trans_factory}{factory that generates transport implementation}
}
\description{
Create server side thrift API
}
\examples{
\dontrun{
# File calc.thrift content:
# service Calculator {
#   i32 add(1:i32 a, 2:i32 b);
#   i32 sub(1:i32 a, 2:i32 b);
#   i32 mult(1:i32 a, 2:i32 b);
#   i32 div(1:i32 a, 2:i32 b);
# }
#

calc_thrift <- thriftr::t_load("calc.thrift", module_name="calc_thrift")

Dispatcher <- R6::R6Class("Dispatcher",
  public = list(
    add = function(a, b) {
      print(sprintf("add -> \%s + \%s", a, b))
      return(a + b)
    },
    sub = function(a, b) {
      print(sprintf("sub -> \%s - \%s", a, b))
      return(a - b)
    },
    mult = function(a, b) {
      print(sprintf("mult -> \%s * \%s", a, b))
      return(a * b)
    },
    div = function(a, b) {
      print(sprintf("div -> \%s / \%s", a, b))
      return(a / b)
    }
  )
)

server <- thriftr::make_server(
    calc_thrift$Calculator,
    Dispatcher$new(),
    "127.0.0.1",
    6000)

print("serving...")

server$serve()
}
}
