% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series.R
\encoding{UTF-8}
\name{bde_series_load}
\alias{bde_series_load}
\title{Load a single BdE time-series.}
\usage{
bde_series_load(
  series_code,
  series_label = NULL,
  parse_dates = TRUE,
  parse_numeric = TRUE,
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE,
  extract_metadata = FALSE
)
}
\arguments{
\item{series_code}{a numeric (or coercible with \code{\link[base:double]{base::as.double()}} value
or vector with time-series code(s), as defined in the field
\verb{Número secuencial} of the corresponding series. See \code{\link[=bde_catalog_load]{bde_catalog_load()}}.}

\item{series_label}{Optional. Character vector or value. Allows to specify a
custom label for the series extracted. It should have the same length than
\code{series_code}.}

\item{parse_dates}{Logical. If \code{TRUE} the dates would be parsed using
\code{\link[=bde_parse_dates]{bde_parse_dates()}}.}

\item{parse_numeric}{Logical. If \code{TRUE} the columns would be parsed to
double (numeric) values. See \strong{Note}.}

\item{cache_dir}{A path to a cache directory. The directory can also be set
via options with \code{options(bde_cache_dir = "path/to/dir")}.}

\item{update_cache}{Logical. If \code{TRUE} the requested file would be updated on
the \code{cache_dir}.}

\item{verbose}{Logical \code{TRUE} or \code{FALSE}, display information useful for
debugging.}

\item{extract_metadata}{Logical \code{TRUE/FALSE}. On \code{TRUE} the output is the
metadata of the requested series.}
}
\value{
A tibble with a field "Date" and the \code{series_code} of the series as
described on the catalogs. See \code{\link[=bde_catalog_load]{bde_catalog_load()}}.
}
\description{
The series alias is a positional code showing the location (column and/or
row) of the series in the table. However, although it is unique, it is not
a good candidate to be used as the series ID, as it is subject to change.
If a series changes position in the table, its alias will also change.

To ensure series can still be identified, even after these changes, they
are assigned a sequential number (\code{series_code} on this function) which
will remain unchanged throughout the series' lifetime.

Note that a single series could be used on different tables, so it can have
several aliases. If you need to search by alias it is recommended to use
\code{\link[=bde_series_full_load]{bde_series_full_load()}}.
}
\details{
Load a single time-series provided by BdE.
}
\note{
This function tries to coerce the columns to numbers. For some series a
warning may be displayed if the parser fails. You can override the default
behavior with \code{parse_numeric = FALSE}
}
\examples{
\dontshow{if (bde_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Metadata
bde_series_load(573234, verbose = TRUE, extract_metadata = TRUE)

# Data
bde_series_load(573234, extract_metadata = FALSE)

# Vectorized
bde_series_load(c(573234, 573214),
  series_label = c("US/EUR", "GBP/EUR"),
  verbose = TRUE, extract_metadata = TRUE
)

bde_series_load(c(573234, 573214),
  series_label = c("US/EUR", "GBP/EUR"),
  verbose = TRUE, extract_metadata = FALSE
)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=bde_catalog_load]{bde_catalog_load()}},
\code{\link[=bde_catalog_search]{bde_catalog_search()}}, \code{\link[=bde_indicators]{bde_indicators()}}

Other series: 
\code{\link{bde_series_full_load}()}
}
\concept{series}
