% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{add_tile}
\alias{add_tile}
\alias{add_tile,InputHeatmap-method}
\title{Adds a tile annotation layer to a `InputHeatmap`, that on evaluation creates a `ComplexHeatmap`}
\usage{
add_tile(.data, .column, palette = NULL)

\S4method{add_tile}{InputHeatmap}(.data, .column, palette = NULL)
}
\arguments{
\item{.data}{A `tbl_df` formatted as | <ELEMENT> | <FEATURE> | <VALUE> | <...> |}

\item{.column}{Vector of quotes}

\item{palette}{A character vector of colors  This is the list of palettes that will be used for horizontal and vertical discrete annotations. The discrete classification of annotations depends on the column type of your input tibble (e.g., character and factor).}
}
\value{
A `InputHeatmap` object that gets evaluated to a `ComplexHeatmap`

A `add_tile` object
}
\description{
add_tile() from a `InputHeatmap` object, adds a tile annotation layer.
}
\details{
\lifecycle{maturing}

It uses `ComplexHeatmap` as visualisation tool.
}
\examples{

library(dplyr)

hm = 
  tidyHeatmap::N52 \%>\%
  tidyHeatmap::heatmap(
    .row = symbol_ct,
    .column = UBR,
    .value = `read count normalised log`
)

hm \%>\% add_tile(CAPRA_TOTAL)


}
