% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_heatmap.R
\name{micro_heatmap}
\alias{micro_heatmap}
\title{Create heatmaps of estiamted coefficients from negative binomial models}
\usage{
micro_heatmap(
  modsum,
  low_grad,
  high_grad,
  mid_grad,
  midpoint = 0,
  top_taxa = 10,
  low_lim,
  high_lim,
  mute_cols = T,
  alpha = 0.05,
  dot_size = 2,
  dot_shape = 8,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  subtitle = NULL,
  xaxis = NULL,
  legend_title = NULL,
  caption = NULL
)
}
\arguments{
\item{modsum}{The output from nb_mods}

\item{low_grad}{The low gradient colors for the coefficient magnitude. Will be fed into scale_fill_gradient}

\item{high_grad}{The high gradient colors for the coefficient magnitude. Will be fed into scale_fill_gradient}

\item{mid_grad}{The medium gradient colors for the coefficient magnitude. Will be fed into scale_fill_gradient}

\item{midpoint}{Midpoint for coefficient magnitude in legend}

\item{top_taxa}{Only plot X taxa with the largest magnitude beta coefficients}

\item{low_lim}{Lower limits of the fill gradient. Will default to the largest magnitude effect size}

\item{high_lim}{Upper limits of the fill gradient. Will default to the largest magnitude effect size}

\item{mute_cols}{Mute the colors of the fill gradients}

\item{alpha}{Mark beta coefficient cells with p-values below this cutoff}

\item{dot_size}{size of marker in cells}

\item{dot_shape}{shape of marker in cells}

\item{main}{Plot title}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{subtitle}{Plot label}

\item{xaxis}{Labels for the x-axis ticks}

\item{legend_title}{Title of figure legend}

\item{caption}{plot caption to be displayed at the bottom of plot}
}
\value{
Returns a ggplot that you can add geoms to if you'd like
}
\description{
A function to create heatmaps of estimated beta coeffients from each model fit by nb_mods
}
\details{
The output will give gray columns if there are missing values in the supplied continuous variable
}
\examples{
data(phy); data(cla); data(ord); data(fam); data(clin)

otu_tabs = list(Phylum = phy, Class = cla, Order = ord, Family = fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = clin) \%>\%
filter(day == 7) ## Only including the first week

## Creating negative binomial models on filtered tidy_micro set
nb_fam <- set \%>\%
mutate(bpd1 = factor(bpd1)) \%>\% ## making bpd1 a factor
otu_filter(ra_cutoff = 0.1, exclude_taxa = c("Unclassified", "Bacteria")) \%>\%
nb_mods(table = "Family", bpd1)

nb_fam \%>\% micro_heatmap
}
