% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_pca.R
\name{micro_pca}
\alias{micro_pca}
\title{Calculate and plot principle components}
\usage{
micro_pca(
  micro_set,
  table = NULL,
  dist = NULL,
  grp_var,
  y = clr,
  scale = TRUE,
  axes_arrows = F,
  ellipse = FALSE,
  ellipse.prob = 0.68,
  main = NULL,
  subtitle = NULL,
  legend_title = NULL
)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{table}{OTU table of interest}

\item{dist}{A distance matrix, such as a beta diversity. If supplied a PCoA plot will be returned}

\item{grp_var}{Categorical grouping variable}

\item{y}{Value to calculate principle components or coordinates on. Default is centered log ratio (recommended)}

\item{scale}{Logical. Indicating whether the variables should be scaled to have unit variance before the analysis takes place}

\item{axes_arrows}{Logical. Plot component axes arrows}

\item{ellipse}{Logical. Plot normal data ellipses by groups}

\item{ellipse.prob}{Numeric.}

\item{main}{Plot title}

\item{subtitle}{Plot subtitle}

\item{legend_title}{Legend title}
}
\value{
A ggplot you can add geoms to if you'd like
}
\description{
Principle components are calculated on the centerted log ratio tranformation of the OTU table using the \code{\link[stats]{prcomp}} function from the \code{\link{stats}} package. Scaling the OTU table to a unit variance is the default option, and recommended, but this can be changed using scaled = F.
}
\details{
PCA calculation is done by a singular value decomposition of the (centered and possibly scaled) data matrix, not by using eigen on the covariance matrix. This is generally the preferred method for numerical accuracy. Calculations are accomplished through the \code{\link[stats]{prcomp}} function, and the plot is created through internal code based on the ggbiplot function \url{https://github.com/vqv/ggbiplot}.
}
\examples{
data(mrsa_gen); data(mrsa_clin)

set <- tidy_micro(otu_tabs = mrsa_gen, tab_names = "Genus", clinical = mrsa_clin)

## PCA Plot
set \%>\% micro_pca(table = "Genus", grp_var = Aureus_Positive)

## PCoA Plot (Recommended for p > n)

bray_beta <- set \%>\% beta_div(table = "Genus")
micro_pca(set, dist = bray_beta, grp_var = Aureus_Positive, ellipse = TRUE)

}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) The New S Language. Wadsworth & Brooks/Cole.

Mardia, K. V., J. T. Kent, and J. M. Bibby (1979) Multivariate Analysis, London: Academic Press.

Venables, W. N. and B. D. Ripley (2002) Modern Applied Statistics with S, Springer-Verlag.

Vincent Q. Vu (2011). ggbiplot: A ggplot2 based biplot. \url{https://github.com/vqv/ggbiplot}
}
