% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ra_bars.R
\name{ra_bars}
\alias{ra_bars}
\title{Function to make stacked bar charts of taxa relative abundance}
\usage{
ra_bars(
  micro_set,
  table,
  ...,
  top_taxa = 0,
  RA = 0,
  specific_taxa,
  main,
  subtitle,
  ylab,
  xlab,
  xaxis,
  lines = TRUE
)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{table}{OTU table you'd like to use when calculating alpha diversity. Your lowest level is recommended}

\item{...}{A categorical variable by which you'd like to stratify your relative abundances}

\item{top_taxa}{Only plot X taxa with the highest relative abundance. The rest will be aggregated into an "Other" category.}

\item{RA}{Only plot taxa with a relative abundance higher than X. The rest will be aggregated into an "Other" category.}

\item{specific_taxa}{Plot this specific taxa even if it doesn't meet the top_taxa or RA requirements}

\item{main}{Plot title}

\item{subtitle}{Subtitle for the plot}

\item{ylab}{y-axis label}

\item{xlab}{x-axis label}

\item{xaxis}{Labels for the x-axis ticks. Most useful for categorical variables and defaults to the levels}

\item{lines}{Logical; Add outlines around the different taxa colors in the stacked bar charts}
}
\value{
Returns a ggplot that you can add geoms to if you'd like
}
\description{
A function to make stacked bar charts of taxa relative abuncance with the choice to stratify by a variable of interest
}
\examples{
data(bpd_phy); data(bpd_cla); data(bpd_ord); data(bpd_fam); data(bpd_clin)
otu_tabs = list(Phylum = bpd_phy, Class = bpd_cla,
Order = bpd_ord, Family = bpd_fam)

set <- tidy_micro(otu_tabs = otu_tabs, clinical = bpd_clin) \%>\%
filter(day == 7) ## Only including the first week

## Full cohort abundance
set \%>\%
ra_bars(table = "Family", top_taxa = 10)

## Stratified by variable of interest
set \%>\%
ra_bars(table = "Family", bpd1, top_taxa = 10)
}
