% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_switch_labels.R
\name{mx_switch_labels}
\alias{mx_switch_labels}
\title{Switch LCA Class Labels}
\usage{
mx_switch_labels(x, param = "weights", decreasing = TRUE, order = NULL)
}
\arguments{
\item{x}{An \code{MxModel} estimated by \code{mx_mixture} or one of its wrappers.}

\item{param}{The parameter by which to order the classes,
defaults to \code{'weights'}, which orders classes based on their sample size.}

\item{decreasing}{logical. Should the classes be sorted in increasing
or decreasing order? Default: TRUE}

\item{order}{Integer, indicating the ordering of classes. Ignored
when NULL (default).}
}
\value{
An \code{MxModel} with \code{"tidySEM"} attribute: \code{"mixture"}
}
\description{
The order of class labels in LCA is arbitrary. This can
result in a phenomenon called 'label switching', where classes change
places between replications of an analysis. This function attempts to
re-order classes in a substantively meaningful way.
}
\details{
The argument \code{param} can accept either:
\enumerate{
\item The default string "weights", in which classes are sorted by size.
\item The \code{OpenMx} matrix indicator for a specific model parameter; e.g.,
the first mean is indicated by \code{"M[1,1]"}. These indicators can be viewed
by running \code{table_results(x, columns = NULL)}.
\item The letter indicating an \code{OpenMx} model matrix, e.g., \code{"M"} refers to
the matrix of means. To account for all elements of the matrix, Euclidean
distance to the origin is used.
}
}
\examples{
\dontrun{
df <- iris[1:4]
names(df) <- letters[1:4]
res1 <- mx_profiles(data = df, classes = 2)
mx_switch_labels(res1, decreasing = FALSE)
}
}
