% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual_functions.R
\name{visual_crop}
\alias{visual_crop}
\alias{visual_va_classify}
\alias{visual_data_block_inspection}
\alias{visual_orientation_modification}
\alias{visual_traceback}
\title{Interactive operations and Visualizations}
\usage{
visual_crop(d)

visual_va_classify(d)

visual_data_block_inspection(x)

visual_orientation_modification(x)

visual_traceback(x, dcomp)
}
\arguments{
\item{d}{a cell_df.}

\item{x}{a cell_analysis.}

\item{dcomp}{a composition (a tibble rendered by \code{\link[=compose_cells]{compose_cells}}).}
}
\value{
\code{visual_crop} returns a cell_df after the interactive operations.

\code{visual_va_classify} returns a cell_df after the interactive operations.

\code{visual_orientation_modification} returns a cell_analysis after the interactive operations.

\code{visual_traceback} returns a composed tidy data (as a tibble).
}
\description{
These functions require \code{\link[shiny:shiny-package]{shiny}} and \code{miniUI}.
Each of these modules has option for interactive plots (using \code{plotly}).
However, for the same you need to have \code{plotly} installed.
}
\details{
Each of these functions are designed for interactive sessions only.
Arguments to these functions are optional as it tries to pick those from global environment.
If there are multiple variables defined in global environment which are of same desired class then you will get option to choose
one of them. These are also available as \href{https://rstudio.github.io/rstudioaddins/}{RStudio Addin}
(if you are using RStudio IDE you'll get those addin in the RStudio addin panel).

Following are the names used in RStudio Addin
\itemize{
\item \emph{Crop Cells}: \code{visual_crop}
\item \emph{Cell Analysis Inspection}: \code{visual_data_block_inspection}
\item \emph{Orientation Modification}: \code{visual_orientation_modification}
\item \emph{Traceback Composition}: \code{visual_traceback}
\item \emph{Classify Value/Attribute}: \code{visual_va_classify}
}

For each of the modules it tries to load and unload \code{shiny} before and after the execution of the module.
You can disable the same by setting \code{options(AutoUnloadShiny = FALSE)}.

\code{visual_traceback} requires package \code{DT}.
If \code{DT} is not present you may use \code{\link[=cell_composition_traceback]{cell_composition_traceback}}
}
\seealso{
\code{\link[=value_attribute_classify]{value_attribute_classify}}

\code{\link[=cell_composition_traceback]{cell_composition_traceback}}
}
\keyword{internal}
