% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimates.R
\name{get_estimates}
\alias{get_estimates}
\title{Get data from the US Census Bureau Population Estimates APIs}
\usage{
get_estimates(
  geography,
  product = NULL,
  variables = NULL,
  breakdown = NULL,
  breakdown_labels = FALSE,
  year = 2018,
  state = NULL,
  county = NULL,
  time_series = FALSE,
  output = "tidy",
  geometry = FALSE,
  keep_geo_vars = FALSE,
  shift_geo = FALSE,
  key = NULL,
  show_call = FALSE,
  ...
)
}
\arguments{
\item{geography}{The geography of your data.}

\item{product}{The data product (optional). \code{"population"}, \code{"components"}
\code{"housing"}, and \code{"characteristics"} are supported.}

\item{variables}{A character string of requested variables to get specific
variables from the population, components, and housing APIs.}

\item{breakdown}{The population breakdown used when \code{product = "characteristics"}.
Acceptable values are \code{"AGEGROUP"}, \code{"RACE"}, \code{"SEX"}, and
\code{"HISP"}, for Hispanic/Not Hispanic.  These values can be combined in
a vector, returning population estimates in the \code{value} column for all
combinations of these breakdowns.}

\item{breakdown_labels}{Whether or not to label breakdown elements returned when
\code{product = "characteristics"}. Defaults to FALSE.}

\item{year}{The data year (defaults to 2018)}

\item{state}{The state for which you are requesting data. State
names, postal codes, and FIPS codes are accepted.
Defaults to NULL.}

\item{county}{The county for which you are requesting data. County names and
FIPS codes are accepted. Must be combined with a value supplied
to `state`.  Defaults to NULL.}

\item{time_series}{If \code{TRUE}, the function will return a time series of observations back to the decennial Census
of 2010. The returned column is either "DATE", representing a particular estimate date, or "PERIOD",
representing a time period (e.g. births between 2016 and 2017), and contains integers representing
those values.  Integer to date or period mapping is available at
\url{https://www.census.gov/data/developers/data-sets/popest-popproj/popest/popest-vars/2018.html}.}

\item{output}{One of "tidy" (the default) in which each row represents an
enumeration unit-variable combination, or "wide" in which each
row represents an enumeration unit and the variables are in the
columns.}

\item{geometry}{if FALSE (the default), return a regular tibble of ACS data.
if TRUE, uses the tigris package to return an sf tibble
with simple feature geometry in the `geometry` column.}

\item{keep_geo_vars}{if TRUE, keeps all the variables from the Census
shapefile obtained by tigris.  Defaults to FALSE.}

\item{shift_geo}{if TRUE, returns geometry with Alaska and Hawaii shifted for thematic
mapping of the entire US.}

\item{key}{Your Census API key.
Obtain one at \url{http://api.census.gov/data/key_signup.html}.  Can be stored
in your .Renviron with \code{census_api_key("YOUR KEY", install = TRUE)}}

\item{show_call}{if TRUE, display call made to Census API. This can be very useful
in debugging and determining if error messages returned are
due to tidycensus or the Census API. Copy to the API call into
a browser and see what is returned by the API directly. Defaults to FALSE.}

\item{...}{other keyword arguments}
}
\value{
A tibble, or sf tibble, of population estimates data
}
\description{
Get data from the US Census Bureau Population Estimates APIs
}
