% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-seg_cpt.R
\name{new_seg_cpt}
\alias{new_seg_cpt}
\alias{seg_cpt}
\title{Base class for segmenters}
\usage{
new_seg_cpt(
  x = numeric(),
  pkg = character(),
  base_class = character(),
  algorithm = NA,
  changepoints = integer(),
  fitness = double(),
  seg_params = list(),
  model_name = "meanshift_norm",
  penalty = "BIC",
  ...
)

seg_cpt(x, ...)
}
\arguments{
\item{x}{a numeric vector coercible into a \code{\link[stats:ts]{stats::ts()}} object}

\item{pkg}{name of the package providing the segmenter}

\item{base_class}{class of the underlying object}

\item{algorithm}{Algorithm used to find the changepoints}

\item{changepoints}{a possibly empty \code{\link[=list]{list()}} of candidate changepoints}

\item{fitness}{A named \code{double} vector whose name reflects the penalty applied}

\item{seg_params}{a possibly empty \code{\link[=list]{list()}} of segmenter parameters}

\item{model_name}{character indicating the model used to find the changepoints.}

\item{penalty}{character indicating the name of the penalty function used to
find the changepoints.}

\item{...}{currently ignored}
}
\value{
A \link{seg_cpt} object.
}
\description{
Base class for segmenters
}
