% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winsorize.R
\name{winsorize}
\alias{winsorize}
\title{Winsorize a Numeric Vector}
\usage{
winsorize(x, cut)
}
\arguments{
\item{x}{A numeric vector to be winsorized.}

\item{cut}{The proportion of data to be winsorized from both ends of the
distribution. For example, a \code{cut} of 0.05 will winsorize the lowest and
highest 5\% of the data. Must be inside [0, 0.5].}
}
\value{
A numeric vector with the extreme values replaced by the
corresponding quantile values.
}
\description{
Replaces the values in a numeric vector that are beyond the specified
quantiles with the boundary values of those quantiles. This is done for both
tails of the distribution based on the \code{cut} parameter.
}
\examples{
set.seed(123)
data <- rnorm(100)
winsorized_data <- winsorize(data, 0.05)
}
