% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.boost.R
\name{.fit.boost}
\alias{.fit.boost}
\title{Gradient boosting regression for \code{tidyfit}}
\usage{
\method{.fit}{boost}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.

A 'tibble'.
}
\description{
Fits a gradient boosting regression or classification on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}} and \code{\link{classify}}.
}
\details{
\strong{Hyperparameters:}
\itemize{
\item \code{mstop} (\emph{number of boosting iterations})
\item \code{nu} (\emph{step size})
}

\strong{Important method arguments (passed to \code{\link{m}})}

The gradient boosting regression is performed using \code{mboost::glmboost}. See \code{?glmboost} for more details.

\strong{Implementation}

Features are standardized by default with coefficients transformed to the original scale.

If no hyperparameter grid is passed (\code{is.null(control$mstop)} and \code{is.null(control$nu)}), the default grid is used with \code{mstop = c(100, 500, 1000, 5000)} and \code{nu = c(0.01, 0.05, 0.1, 0.15, 0.2, 0.25)}.
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns

# Stand-alone function
fit <- m("boost", Return ~ ., data, nu = 0.1, mstop = 100)
fit

# Within 'regress' function
fit <- regress(data, Return ~ ., m("boost", nu = c(0.1, 0.05), mstop = 100),
               .mask = c("Date", "Industry"))
coef(fit)

}
\references{
T. Hothorn, P. Buehlmann, T. Kneib, M. Schmid, and B. Hofner (2022). mboost: Model-Based Boosting, R package version 2.9-7,https://CRAN.R-project.org/package=mboost.
}
\seealso{
\code{\link{m}} method
}
\author{
Johann Pfitzinger
}
