% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sys_time_print.R
\name{sys_time_print}
\alias{sys_time_print}
\alias{pst}
\title{Convenient print of time taken}
\usage{
sys_time_print(expr)

pst(expr)
}
\arguments{
\item{expr}{Valid R expression to be timed.}
}
\value{
A character vector of the form HH:MM:SS,
or SS.MMMsec if under 60 seconds (invisibly for \code{show_time}). See examples.
}
\description{
Convenient printing of time elapsed. A wrapper of
\code{data.table::timetaken}, but showing the results more directly.
}
\examples{

sys_time_print(Sys.sleep(1))

a = iris
sys_time_print({
  res = iris \%>\%
    mutate_dt(one = 1)
})
res
}
\seealso{
\code{\link[data.table]{timetaken}}, \code{\link[base]{system.time}}
}
