% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_by.R
\name{group_by}
\alias{group_by}
\alias{group_exe}
\alias{groups}
\alias{ungroup}
\title{Group by one or more variables}
\usage{
group_by(.data, ...)

group_exe(.data, ...)

groups(x)

ungroup(x)
}
\arguments{
\item{.data}{A data.table}

\item{...}{For \code{group_by}:Variables to group by.
For \code{group_exe}:Any data manipulation arguments that
 could be implemented on a data.table.}

\item{x}{A data.table}
}
\value{
A data.table with keys
}
\description{
Most data operations are done on groups defined by variables.
\code{group_by} will group the data.table by selected variables (setting
them as keys), and arrange them in ascending order.
\code{group_exe} could do computations by group, it receives an object
returned by \code{group_by}.
}
\details{
For \code{mutate} and \code{summarise}, it is recommended to
 use the innate "by" parameter, which is faster. Once the data.table is
 grouped, the order is changed forever.

\code{groups()} could return a character vector of specified groups.

\code{ungroup()} would delete the keys in data.table.
}
\examples{
a = as.data.table(iris)
a
a \%>\%
  group_by(Species) \%>\%
  group_exe(
    head(3)
  )
groups(a)
ungroup(a)
groups(a)
}
