% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersect.R
\name{genome_intersect}
\alias{genome_intersect}
\title{Intersect data frames based on chromosome, start and end.}
\usage{
genome_intersect(x, y, by = NULL, mode = "both")
}
\arguments{
\item{x}{A dataframe.}

\item{y}{A dataframe.}

\item{by}{A character vector with 3 entries which are used to match the chromosome, start and end column.
For example: \code{by=c("Chromosome"="chr", "Start"="start", "End"="end")}}

\item{mode}{One of "both", "left", "right" or "anti".}
}
\value{
The intersected dataframe of \code{x} and \code{y} with the new boundaries.
}
\description{
Intersect data frames based on chromosome, start and end.
}
\examples{

library(dplyr)

x1 <- data.frame(id = 1:4, bla=letters[1:4],
                 chromosome = c("chr1", "chr1", "chr2", "chr2"),
                 start = c(100, 200, 300, 400),
                 end = c(150, 250, 350, 450))

x2 <- data.frame(id = 1:4, BLA=LETTERS[1:4],
                 chromosome = c("chr1", "chr2", "chr2", "chr1"),
                 start = c(140, 210, 400, 300),
                 end = c(160, 240, 415, 320))
j <- genome_intersect(x1, x2, by=c("chromosome", "start", "end"), mode="both")
print(j)


}
