% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play.R
\name{type_games}
\alias{type_games}
\alias{play_preference}
\alias{play_preference_asym}
\alias{play_bipartite}
\alias{play_traits}
\alias{play_citation_type}
\title{Graph games based on different node types}
\usage{
play_preference(n, n_types, p_type = rep(1, n_types), p_pref = matrix(1,
  n_types, n_types), fixed = FALSE, directed = TRUE, loops = FALSE)

play_preference_asym(n, n_types, p_type = matrix(1, n_types, n_types),
  p_pref = matrix(1, n_types, n_types), loops = FALSE)

play_bipartite(n1, n2, p, m, directed = TRUE, mode = "out")

play_traits(n, n_types, growth = 1, p_type = rep(1, n_types),
  p_pref = matrix(1, n_types, n_types), callaway = TRUE, directed = TRUE)

play_citation_type(n, growth, types = rep(0, n), p_pref = rep(1,
  length(unique(types))), directed = TRUE)
}
\arguments{
\item{n, n1, n2}{The number of nodes in the graph. For bipartite graphs \code{n1}
and \code{n2} specifies the number of nodes of each type.}

\item{n_types}{The number of different node types in the graph}

\item{p_type}{The probability that a node will be the given type. Either a
vector or a matrix, depending on the game}

\item{p_pref}{The probability that an edge will be made to a type. Either a
vector or a matrix, depending on the game}

\item{fixed}{Should n_types be understood as a fixed number of nodes for each
type rather than as a probability}

\item{directed}{Should the resulting graph be directed}

\item{loops}{Are loop edges allowed}

\item{p}{The probabilty of an edge occuring}

\item{m}{The number of edges in the graph}

\item{mode}{The flow direction of edges}

\item{growth}{The number of edges added at each iteration}

\item{callaway}{Use the callaway version of the trait based game}

\item{types}{The type of each node in the graph, enumerated from 0}
}
\value{
A tbl_graph object
}
\description{
This set of games are build around different types of nodes and simulating
their interaction. The nature of their algorithm is described in
detail at the linked igraph documentation.
}
\section{Functions}{
\itemize{
\item \code{play_preference}: Create graphs by linking nodes of different types
based on a defined probability. See \code{\link[igraph:sample_pref]{igraph::sample_pref()}}

\item \code{play_preference_asym}: Create graphs by linking nodes of different types
based on an asymmetric probability. See \code{\link[igraph:sample_asym_pref]{igraph::sample_asym_pref()}}

\item \code{play_bipartite}: Create bipartite graphs of fixed size and edge count
or probability. See \code{\link[igraph:sample_bipartite]{igraph::sample_bipartite()}}

\item \code{play_traits}: Create graphs by evolving a graph with type based edge
probabilities. See \code{\link[igraph:sample_traits]{igraph::sample_traits()}} and
\code{\link[igraph:sample_traits_callaway]{igraph::sample_traits_callaway()}}

\item \code{play_citation_type}: Create citation graphs by evolving with type based
linking probability. See \code{\link[igraph:sample_cit_types]{igraph::sample_cit_types()}} and
\code{\link[igraph:sample_cit_cit_types]{igraph::sample_cit_cit_types()}}
}}

\examples{
plot(play_bipartite(20, 30, 0.4))

}
\seealso{
Other graph games: \code{\link{component_games}},
  \code{\link{evolution_games}},
  \code{\link{sampling_games}}
}
\concept{graph games}
