% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_stn_.R
\name{hy_stn_datum_unrelated}
\alias{hy_stn_datum_unrelated}
\title{Extract station datum unrelated from HYDAT database}
\format{A tibble with 4 variables:
\describe{
  \item{STATION_NUMBER}{Unique 7 digit Water Survey of Canada station number}
  \item{DATUM_ID}{Unique code identifying a datum}
  \item{YEAR_FROM}{First year of use}
  \item{YEAR_TO}{Last year of use}
}}
\usage{
hy_stn_datum_unrelated(station_number = NULL, hydat_path = NULL,
  prov_terr_state_loc = NULL)
}
\arguments{
\item{station_number}{A seven digit Water Survey of Canada station number. If this argument is omitted, the value of \code{prov_terr_state_loc}
is returned.}

\item{hydat_path}{The default for this argument is to look for hydat in the same location where it
was saved by using \code{download_hydat}. Therefore this argument is almost always omitted from a function call. 
You can see where hydat was downloaded using \code{hy_dir()}}

\item{prov_terr_state_loc}{Province, state or territory. If this argument is omitted, the value of \code{station_number}
is returned. See \code{unique(allstations$prov_terr_state_loc)}}
}
\value{
A tibble of hy_stn_datum_unrelated
}
\description{
hy_stn_datum_unrelated look-up Table
}
\examples{
\dontrun{
hy_stn_datum_unrelated()
}

}
