% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/append_values.r
\name{append_values}
\alias{append_values}
\alias{append_values_logical}
\alias{append_values_number}
\alias{append_values_string}
\title{Appends all values with a specified type as a new column}
\usage{
append_values_string(x, column.name = type, force = TRUE)

append_values_number(x, column.name = type, force = TRUE)

append_values_logical(x, column.name = type, force = TRUE)
}
\arguments{
\item{x}{a tbl_json object}

\item{column.name}{the column.name to append the values into the data.frame
under}

\item{force}{parameter that determines if the variable type should be computed or not
if force is FALSE, then the function may take more memory}
}
\description{
The append_values_X functions let you take any remaining JSON and add it as
a column X (for X in "string", "number", "logical") insofar as it is of the
JSON type specified.
}
\details{
Any values that do not conform to the type specified will be NA in the resulting
column. This includes other scalar types (e.g., numbers or logicals if you are
using append_values_string) and *also* any rows where the JSON is still an
object or an array.
}
\examples{
library(magrittr)  # for \%>\%
'{"first": "bob", "last": "jones"}' \%>\%
  gather_keys() \%>\%
  append_values_string()
}

