% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-proportional.R
\name{add_barstack_absolute}
\alias{add_barstack_absolute}
\alias{add_barstack_relative}
\title{Add bar stack}
\usage{
add_barstack_absolute(plot, width = 0.8, reverse = FALSE, ...)

add_barstack_relative(plot, width = 0.8, reverse = FALSE, ...)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{width}{Width of the plot area. Defaults to \code{50}.}

\item{reverse}{Whether the order should be reversed or not. Defaults to \code{FALSE}, meaning not reversed.}

\item{...}{Arguments passed on to the \code{geom} function.}
}
\value{
A \code{tidyplot} object.
}
\description{
Add bar stack
}
\examples{
# for a `count` only provide `color`
# `count` of the data points in each `energy_type` category
energy |>
  tidyplot(color = energy_type) |>
  add_barstack_absolute()

energy |>
  tidyplot(color = energy_type) |>
  add_barstack_relative()

# for a `sum` provide `color` and `y`
# `sum` of `energy` in each `energy_type` category
energy |>
  tidyplot(y = energy, color = energy_type) |>
  add_barstack_absolute()

energy |>
  tidyplot(y = energy, color = energy_type) |>
  add_barstack_relative()

# Include variable on second axis
energy |>
  tidyplot(x = year, y = energy, color = energy_type) |>
  add_barstack_absolute()

energy |>
  tidyplot(x = year, y = energy, color = energy_type) |>
  add_barstack_relative()

# Flip x and y-axis
energy |>
  tidyplot(x = energy, y = year, color = energy_type) |>
  add_barstack_absolute(orientation = "y")

energy |>
  tidyplot(x = energy, y = year, color = energy_type) |>
  add_barstack_relative(orientation = "y")

}
