% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spread.R
\name{spread}
\alias{spread}
\title{Spread a key-value pair across multiple columns.}
\usage{
spread(data, key, value, fill = NA, convert = FALSE, drop = TRUE,
  sep = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{key}{The bare (unquoted) name of the column whose values will be used
as column headings.}

\item{value}{The bare (unquoted) name of the column whose values will
populate the cells.}

\item{fill}{If set, missing values will be replaced with this value. Note
that there are two types of missingness in the input: explicit missing
values (i.e. \code{NA}), and implicit missings, rows that simply aren't
present. Both types of missing value will be replaced by \code{fill}.}

\item{convert}{If \code{TRUE}, \code{\link{type.convert}} with \code{asis =
TRUE} will be run on each of the new columns. This is useful if the value
column was a mix of variables that was coerced to a string. If the class of
the value column was factor or date, note that will not be true of the new
columns that are produced, which are coerced to character before type
conversion.}

\item{drop}{If \code{FALSE}, will keep factor levels that don't appear in the
data, filling in missing combinations with \code{fill}.}

\item{sep}{If \code{NULL}, the column names will be taken from the values of
\code{key} variable. If non-\code{NULL}, the column names will be given
by "<key_name><sep><key_value>".}
}
\description{
Spread a key-value pair across multiple columns.
}
\examples{
library(dplyr)
stocks <- data.frame(
  time = as.Date('2009-01-01') + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4)
)
stocksm <- stocks \%>\% gather(stock, price, -time)
stocksm \%>\% spread(stock, price)
stocksm \%>\% spread(time, price)

# Spread and gather are complements
df <- data.frame(x = c("a", "b"), y = c(3, 4), z = c(5, 6))
df \%>\% spread(x, y) \%>\% gather(x, y, a:b, na.rm = TRUE)

# Use 'convert = TRUE' to produce variables of mixed type
df <- data.frame(row = rep(c(1, 51), each = 3),
                 var = c("Sepal.Length", "Species", "Species_num"),
                 value = c(5.1, "setosa", 1, 7.0, "versicolor", 2))
df \%>\% spread(var, value) \%>\% str
df \%>\% spread(var, value, convert = TRUE) \%>\% str
}
\seealso{
\code{\link{spread_}} for a version that uses regular evaluation
  and is suitable for programming with.
}

