% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-rename.R, R/vars-select.R
\name{vars_rename}
\alias{vars_rename}
\alias{vars_select}
\title{Select or rename variables}
\usage{
vars_rename(.vars, ..., .strict = TRUE)

vars_select(.vars, ..., .include = character(), .exclude = character())
}
\arguments{
\item{.vars}{A character vector of existing column names.}

\item{..., args}{Expressions to compute

These arguments are automatically \link[rlang:quo]{quoted} and
\link[rlang:eval_tidy]{evaluated} in a context where elements of
\code{vars} are objects representing their positions within
\code{vars}. They support \link[rlang:quasiquotation]{unquoting} and
splicing. See \code{vignette("programming")} for an introduction to
these concepts.

Note that except for \code{:}, \code{-} and \code{c()}, all complex expressions
are evaluated outside that context. This is to prevent accidental
matching to \code{vars} elements when you refer to variables from the
calling context.}

\item{.strict}{If \code{TRUE}, will throw an error if you attempt to rename a
variable that doesn't exist.}

\item{.include, .exclude}{Character vector of column names to always
include/exclude.}
}
\value{
A named character vector. Values are existing column names,
names are new names.
}
\description{
These functions power \code{\link[dplyr:select]{dplyr::select()}} and \code{\link[dplyr:rename]{dplyr::rename()}}. They
enable dplyr selecting or renaming semantics in your own functions.
}
\section{Context of evaluation}{


Quoting verbs usually support references to both objects from the
data frame and objects from the calling context. Selecting verbs
behave a bit differently.
\itemize{
\item Bare names are evaluated in the data frame only. You cannot refer
to local objects unless you explicitly unquote them with \code{!!}.
\item Calls to helper functions are evaluated in the calling context
only. You can safely and directly refer to local objects.
}
}

\section{Customising error messages}{


For consistency with dplyr, error messages refer to "columns" by
default. This assumes that the variables being selected come from a
data frame. If this is not appropriate for your DSL, you can add an
attribute \code{vars_type} to the \code{.vars} vector to specify alternative
names. This must be a character vector of length 2 whose first
component is the singular form and the second is the plural. For
example, \code{c("variable", "variables")}.
}

\examples{
# Keep variables
vars_select(names(iris), everything())
vars_select(names(iris), starts_with("Petal"))
vars_select(names(iris), ends_with("Width"))
vars_select(names(iris), contains("etal"))
vars_select(names(iris), matches(".t."))
vars_select(names(iris), Petal.Length, Petal.Width)
vars_select(names(iris), one_of("Petal.Length", "Petal.Width"))

df <- as.data.frame(matrix(runif(100), nrow = 10))
df <- df[c(3, 4, 7, 1, 9, 8, 5, 2, 6, 10)]
vars_select(names(df), num_range("V", 4:6))

# Drop variables
vars_select(names(iris), -starts_with("Petal"))
vars_select(names(iris), -ends_with("Width"))
vars_select(names(iris), -contains("etal"))
vars_select(names(iris), -matches(".t."))
vars_select(names(iris), -Petal.Length, -Petal.Width)

# Rename variables
vars_select(names(iris), petal_length = Petal.Length)
vars_select(names(iris), petal = starts_with("Petal"))

# Rename variables preserving all existing
vars_rename(names(iris), petal_length = Petal.Length)

# You can unquote symbols or quosures
vars_select(names(iris), !! quote(Petal.Length))

# And unquote-splice lists of symbols or quosures
vars_select(names(iris), !!! list(quo(Petal.Length), quote(Petal.Width)))


# When selecting with bare symbols, you can only refer to data
# objects. This avoids ambiguity. If you want to refer to local
# objects, you can explicitly unquote them. They must contain
# variable positions (integers) or variable names (strings):
Species <- 2
vars_select(names(iris), Species)     # Picks up `Species` from the data frame
vars_select(names(iris), !! Species)  # Picks up the local object referring to column 2

# On the other hand, function calls behave the opposite way. They
# are evaluated in the local context only and cannot refer to data
# frame objects. This makes it easy to refer to local variables:
x <- "Petal"
vars_select(names(iris), starts_with(x))  # Picks up the local variable `x`


# The .data pronoun is available:
vars_select(names(mtcars), .data$cyl)
vars_select(names(mtcars), .data$mpg : .data$disp)

# However it isn't available within calls since those are evaluated
# outside of the data context. This would fail if run:
# vars_select(names(mtcars), identical(.data$cyl))


# If you're writing a wrapper around vars_select(), pass the dots
# via splicing to avoid matching dotted arguments to vars_select()
# named arguments (`vars`, `include` and `exclude`):
wrapper <- function(...) {
  vars_select(names(mtcars), !!! quos(...))
}

# This won't partial-match on `vars`:
wrapper(var = cyl)

# This won't match on `include`:
wrapper(include = cyl)


# If your wrapper takes named arguments, you need to capture then
# unquote to pass them to vars_select(). See the vignette on
# programming with dplyr for more on this:
wrapper <- function(var1, var2) {
  vars_select(names(mtcars), !! enquo(var1), !! enquo(var2))
}
wrapper(starts_with("d"), starts_with("c"))
}
\seealso{
\code{\link[=vars_pull]{vars_pull()}}
}
\keyword{internal}
