% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_method.R
\name{print}
\alias{print}
\alias{print.Seurat}
\title{Printing tibbles}
\usage{
\method{print}{Seurat}(x, ..., n = NULL, width = NULL, n_extra = NULL)
}
\arguments{
\item{x}{Object to format or print.}

\item{...}{Other arguments passed on to individual methods.}

\item{n}{Number of rows to show. If `NULL`, the default, will print all rows
if less than option `tibble.print_max`. Otherwise, will print
`tibble.print_min` rows.}

\item{width}{Width of text output to generate. This defaults to `NULL`, which
means use `getOption("tibble.width")` or (if also `NULL`)
`getOption("width")`; the latter displays only the columns that fit on one
screen. You can also set `options(tibble.width = Inf)` to override this
default and always print all columns.}

\item{n_extra}{Number of extra columns to print abbreviated information for,
if the width is too small for the entire tibble. If `NULL`, the default,
will print information about at most `tibble.max_extra_cols` extra columns.}
}
\value{
Nothing
}
\description{
`r lifecycle::badge("maturing")`

One of the main features of the `tbl_df` class is the printing:

* Tibbles only print as many rows and columns as fit on one screen,
  supplemented by a summary of the remaining rows and columns.
* Tibble reveals the type of each column, which keeps the user informed about
  whether a variable is, e.g., `<chr>` or `<fct>` (character versus factor).

Printing can be tweaked for a one-off call by calling `print()` explicitly
and setting arguments like `n` and `width`. More persistent control is
available by setting the options described below.

Only the first 5 reduced dimensions are displayed, while all of them are queriable (e.g. ggplot). All dimensions are returned/displayed if as_tibble is used.
}
\section{Package options}{


The following options are used by the tibble and pillar packages
to format and print `tbl_df` objects.
Used by the formatting workhorse `trunc_mat()` and, therefore,
indirectly, by `print.tbl()`.

* `tibble.print_max`: Row number threshold: Maximum number of rows printed.
  Set to `Inf` to always print all rows.  Default: 20.
* `tibble.print_min`: Number of rows printed if row number threshold is
  exceeded. Default: 10.
* `tibble.width`: Output width. Default: `NULL` (use `width` option).
* `tibble.max_extra_cols`: Number of extra columns printed in reduced form.
  Default: 100.
}

\examples{
library(dplyr)
data("pbmc_small")
pbmc_small  \%>\% print()
}
