% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphabet.R
\name{alphabet}
\alias{alphabet}
\title{Get alphabet of given sq object.}
\usage{
alphabet(x)
}
\arguments{
\item{x}{[\code{sq}]\cr
An object to extract alphabet from.}
}
\value{
A character vector of letters of the alphabet.
}
\description{
Returns \code{alphabet} attribute of an object.
}
\details{
Each \code{sq} object have an \strong{alphabet} associated with it. Alphabet
is a set of possible \strong{letters} that can appear in sequences contained
in object. Alphabet is kept mostly as a character vector, where each element
represents one \strong{letter}.

\code{sq} objects of type \strong{ami}, \strong{dna} or \strong{rna} have
fixed, predefined alphabets. In other words, if two \code{sq} objects have
exactly the same type - \strong{ami_bsc}, \strong{dna_ext}, \strong{rna_bsc}
or any other combination - they are ensured to have the same alphabet.

Below are listed alphabets for these types:
\itemize{
\item \strong{ami_bsc} - ACDEFGHIKLMNPQRSTVWY-*
\item \strong{ami_ext} - ABCDEFGHIJKLMNOPQRSTUVWXYZ-*
\item \strong{dna_bsc} - ACGT-
\item \strong{dna_ext} - ACGTWSMKRYBDHVN-
\item \strong{rna_bsc} - ACGU-
\item \strong{rna_ext} - ACGUWSMKRYBDHVN-
}

Other types of \code{sq} objects are allowed to have different alphabets.
Furthermore, having an alphabet exactly identical to one of those above does
not automatically indicate that the type of the sequence is one of those -
e.g., there might be an \strong{atp} \code{sq} that has an alphabet
identical to \strong{ami_bsc} alphabet. To set the type, one should
use the \code{\link{typify}} or \code{`sq_type<-`} function.

The purpose of co-existence of \strong{unt} and \strong{atp} alphabets is
the fact that although there is a standard for format of \emph{fasta} files,
sometimes there are other types of symbols, which do not match the standard.
Thanks to these types, tidysq can import files with customized alphabets.
Moreover, the user may want to group amino acids with similar properties
(e.g., for machine learning) and replace the standard alphabet with symbols
for whole groups. To check details, see \code{\link{read_fasta}},
\code{\link{sq}} and \code{\link{substitute_letters}}.

\strong{Important note:} in \strong{atp} alphabets there is a possibility
of letters appearing that consist of more than one character - this
functionality is provided in order to handle situations like
post-translational modifications, (e.g., using "\code{mA}" to indicate
methylated alanine).

\strong{Important note:} alphabets of \strong{atp} and \strong{unt}
\code{sq} objects are case sensitive. Thus, in their alphabets both
lowercase and uppercase characters can appear simultaneously and they are
treated as different letters. Alphabets of \strong{dna}, \strong{rna} and
\strong{ami} types are always uppercase and all functions converts other
parameters to uppercase when working with \strong{dna}, \strong{rna} or
\strong{ami} - e.g. \code{\link{\%has\%}} operator converts lower letters to
upper when searching for motifs in \strong{dna}, \strong{rna} or
\strong{ami} object.

\strong{Important note:} maximum length of an alphabet is
\strong{30 letters}. The user is not allowed to read fasta files or
construct \code{sq} objects from character vectors that have more than 30
distinct characters in sequences (unless creating \strong{ami}, \strong{dna}
or \strong{rna} objects with \code{ignore_case} parameter set equal to
\code{TRUE}).
}
\seealso{
\code{\link[=sq-class]{sq class}}

Functions from alphabet module:
\code{\link{get_standard_alphabet}()}
}
\concept{alphabet_functions}
