% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-methods.R
\name{as.character.sq}
\alias{as.character.sq}
\title{Convert sq object into character vector}
\usage{
\method{as.character}{sq}(x, ..., NA_letter = getOption("tidysq_NA_letter"))
}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}

\item{...}{further arguments to be passed from or to other methods.}

\item{NA_letter}{[\code{character(1)}]\cr
A string that is used to interpret and display \code{NA} value in the
context of \code{\link[=sq-class]{sq class}}. Default value equals to
"\code{!}".}
}
\value{
A \code{character} vector where each element represents the content
of respective sequence in input \code{sq} object.
}
\description{
Coerces sequences from an \code{\link[=sq-class]{sq}} object to
\code{\link{character}} vector of sequences.
}
\details{
This method for \code{\link[=sq-class]{sq}} class allows converting sequences
from the \code{sq} object into a character vector of length equal to the
length of input. Each element of resulting vector is a separate sequence.
All attributes of the input sq are lost during the conversion to character
vector.
}
\examples{
# Creating an object to work on:
sq_dna <- sq(c("CTGAATGCAGTACCGTAAT", "ATGCCGTAAATGCCAT", "CAGACCANNNATAG"),
             alphabet = "dna_ext")

# Converting sq object into a character vector:
as.character(sq_dna)

}
\seealso{
Functions from output module:
\code{\link{as.matrix.sq}()},
\code{\link{as.sq}()},
\code{\link{export_sq}()},
\code{\link{write_fasta}()}
}
\concept{output_functions}
