% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_anova.R
\name{report_anova}
\alias{report_anova}
\title{Report method for ANOVA models}
\usage{
report_anova(identifier, group = NULL, term = NULL, term_nr = NULL,
  results = getOption("tidystats_list"))
}
\arguments{
\item{identifier}{A character string identifying the model.}

\item{group}{A character string indicating the group containing the
statistics you want to report.}

\item{term}{A character string indicating the term you want to report.}

\item{term_nr}{A number indicating the term you want to report.}

\item{results}{A tidystats list.}
}
\description{
Function to report ANOVA output in APA style.
}
\examples{
# Read in a list of results
results <- read_stats(system.file("results.csv", package = "tidystats"))

# Set the list as the default list
options(tidystats_list = results)

# Report results
report_anova("aov_two_way", term = "condition")
report_anova("aov_two_way", term = "sex")

}
