% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if_else.R
\name{if_else.}
\alias{if_else.}
\title{Fast if_else}
\usage{
if_else.(condition, true, false, missing = NA, ..., ptype = NULL, size = NULL)
}
\arguments{
\item{condition}{Conditions to test on}

\item{true}{Values to return if conditions evaluate to \code{TRUE}}

\item{false}{Values to return if conditions evaluate to \code{FALSE}}

\item{missing}{Value to return if an element of test is \code{NA}}

\item{...}{These dots are for future extensions and must be empty.}

\item{ptype}{Optional ptype to override output type}

\item{size}{Optional size to override output size}
}
\description{
Fast version of \code{base::ifelse()}.
}
\examples{
x <- 1:5
if_else(x < 3, 1, 0)

# Can also be used inside of mutate()
df <- data.table(x = x)

df \%>\%
  mutate(new_col = if_else(x < 3, 1, 0))
}
\keyword{internal}
